/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.service;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.migration.teleport.cloud.client.CloudService;
import com.aliyun.migration.teleport.cloud.entity.AgentQuery;
import com.aliyun.migration.teleport.cloud.entity.AgentVO;
import com.aliyun.migration.teleport.cloud.entity.DataWorksQuery;
import com.aliyun.migration.teleport.cloud.entity.DataWorksResourceGroupDTO;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CloudServiceClient
implements CloudService {
    private static final Logger log = LoggerFactory.getLogger(CloudServiceClient.class);
    private static final String GET_AGENT_LIST_URI = "/api/bigdata/lhm/agent/inner/listAgent";
    private static final String RESOURCE_GROUP_URI = "/api/bigdata/lhm/resource/inner/getDWResourceGroup";
    private String consoleHost;

    public CloudServiceClient(String consoleHost) {
        this.consoleHost = consoleHost;
    }

    @Override
    public DataWorksResourceGroupDTO getResourceGroup(DataWorksQuery query) {
        DataWorksResourceGroupDTO resourceGroup = this.getResourceGroup(query, this.consoleHost);
        if (resourceGroup == null) {
            throw new TeleportException(TeleportStatusCode.SERVERLESS_RESOURCE_GROUP_IS_NOT_EXIST);
        }
        return resourceGroup;
    }

    @Override
    public AgentVO getFirstAgent(AgentQuery query) {
        List<AgentVO> agentList = this.getAgentList(query, this.consoleHost);
        if (CollectionUtils.isEmpty(agentList)) {
            throw new TeleportException(TeleportStatusCode.AGENT_IS_NOT_ACTIVE);
        }
        return agentList.get(0);
    }

    @Override
    public List<AgentVO> getAgentList(AgentQuery query) {
        return this.getAgentList(query, this.consoleHost);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AgentVO> getAgentList(AgentQuery qry, String consoleHost) {
        String url = consoleHost + GET_AGENT_LIST_URI;
        log.info("[GetAgentList] url: {}, cmd: {}", (Object)url, (Object)qry);
        try (HttpResponse httpResponse = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json")).header("Accept", "*/*")).header("x-acs-caller-type", "inner")).header("x-acs-inner-caller-uid", qry.getUserId())).body(JSON.toJSONString((Object)qry)).execute();){
            String responseBody = httpResponse.body();
            log.info("[GetAgentList] responseBody: {}", (Object)responseBody);
            JSONObject response = JSON.parseObject((String)responseBody);
            Boolean success = response.getBoolean("success");
            if (BooleanUtils.isNotTrue((Boolean)success)) {
                throw new TeleportException(TeleportStatusCode.HTTP_REQUEST_ERROR, response.getString("errMessage"));
            }
            String dataStr = response.getString("data");
            if (Objects.isNull(dataStr)) {
                log.error("[GetAgentList] response data is null");
                List<AgentVO> list2 = Collections.emptyList();
                return list2;
            }
            List list = JSON.parseArray((String)dataStr, AgentVO.class);
            return list;
        }
        catch (Exception e) {
            log.error("[GetAgentList] error", (Throwable)e);
            throw new TeleportException(TeleportStatusCode.HTTP_REQUEST_ERROR, (Throwable)e);
        }
    }

    private DataWorksResourceGroupDTO getResourceGroup(DataWorksQuery qry, String consoleHost) {
        DataWorksResourceGroupDTO dataWorksResourceGroupDTO;
        block10: {
            String url = consoleHost + "/api/bigdata/lhm/resource/inner/getDWResourceGroup?tenantId=" + qry.getTenantId() + "&regionId=" + qry.getRegionId();
            log.info("[GetResourceGroup] url: {}, cmd: {}", (Object)url, (Object)qry);
            HttpResponse httpResponse = ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("Content-Type", "application/json")).header("Accept", "*/*")).header("x-acs-caller-type", "inner")).header("x-acs-inner-caller-uid", qry.getTenantId())).execute();
            try {
                String responseBody = httpResponse.body();
                log.info("[GetResourceGroup] responseBody: {}", (Object)responseBody);
                JSONObject response = JSON.parseObject((String)responseBody);
                Boolean success = response.getBoolean("success");
                if (BooleanUtils.isNotTrue((Boolean)success)) {
                    throw new TeleportException(TeleportStatusCode.HTTP_REQUEST_ERROR, response.getString("errMessage"));
                }
                String dataStr = response.getString("data");
                if (Objects.isNull(dataStr)) {
                    log.error("[GetResourceGroup] response data is null");
                    throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY);
                }
                dataWorksResourceGroupDTO = (DataWorksResourceGroupDTO)JSONObject.parseObject((String)dataStr, DataWorksResourceGroupDTO.class);
                if (httpResponse == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("[GetResourceGroup] error", (Throwable)e);
                    throw new TeleportException(TeleportStatusCode.HTTP_REQUEST_ERROR, (Throwable)e);
                }
            }
            httpResponse.close();
        }
        return dataWorksResourceGroupDTO;
    }
}

