/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.response;

import com.aliyun.migration.teleport.cloud.response.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ApiPageResponse<T>
extends ApiResponse {
    private static final long serialVersionUID = 1L;
    private int totalCount = 0;
    private int pageSize = 1;
    private int pageIndex = 1;
    private Collection<T> data;

    public int getPageSize() {
        if (this.pageSize < 1) {
            return 1;
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize < 1 ? 1 : pageSize;
    }

    public int getPageIndex() {
        if (this.pageIndex < 1) {
            return 1;
        }
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex < 1 ? 1 : pageIndex;
    }

    public List<T> getData() {
        if (null == this.data) {
            return Collections.emptyList();
        }
        if (this.data instanceof List) {
            return (List)this.data;
        }
        return new ArrayList<T>(this.data);
    }

    public int getTotalPages() {
        return this.totalCount % this.pageSize == 0 ? this.totalCount / this.pageSize : this.totalCount / this.pageSize + 1;
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public static ApiPageResponse buildSuccess() {
        ApiPageResponse response = new ApiPageResponse();
        response.setSuccess(true);
        return response;
    }

    public static ApiPageResponse buildFailure(String errCode, String errMessage) {
        ApiPageResponse response = new ApiPageResponse();
        response.setSuccess(false);
        response.setErrCode(errCode);
        response.setErrMessage(errMessage);
        return response;
    }

    public static <T> ApiPageResponse<T> of(int pageSize, int pageIndex) {
        ApiPageResponse<T> response = new ApiPageResponse<T>();
        response.setSuccess(true);
        response.setData(Collections.emptyList());
        response.setTotalCount(0);
        response.setPageSize(pageSize);
        response.setPageIndex(pageIndex);
        return response;
    }

    public static <T> ApiPageResponse<T> of(Collection<T> data, int totalCount, int pageSize, int pageIndex) {
        ApiPageResponse<T> response = new ApiPageResponse<T>();
        response.setSuccess(true);
        response.setData(data);
        response.setTotalCount(totalCount);
        response.setPageSize(pageSize);
        response.setPageIndex(pageIndex);
        return response;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiPageResponse)) {
            return false;
        }
        ApiPageResponse other = (ApiPageResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPageIndex() != other.getPageIndex()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApiPageResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTotalCount();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPageIndex();
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "ApiPageResponse(totalCount=" + this.getTotalCount() + ", pageSize=" + this.getPageSize() + ", pageIndex=" + this.getPageIndex() + ", data=" + this.getData() + ")";
    }
}

