/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.oss;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.core.AklessCredProviderFactory;
import com.aliyun.migration.teleport.cloud.client.MessageHandler;
import com.aliyun.migration.teleport.cloud.entity.MnsProperties;
import com.aliyun.migration.teleport.cloud.entity.SinkProperties;
import com.aliyun.migration.teleport.cloud.oss.OssClient;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Message;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OssEventMessageHandler<T>
implements MessageHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(OssEventMessageHandler.class);
    public static final int BATCH_SIZE = 15;
    protected MNSClient mnsClient;
    protected MnsProperties mnsProperties;
    protected SinkProperties ossProperties;
    protected Class<T> messageClazz;

    public OssEventMessageHandler(MnsProperties mnsProperties, SinkProperties ossProperties, Class<T> messageClazz) {
        this.mnsProperties = mnsProperties;
        this.ossProperties = ossProperties;
        try {
            CloudAccount account = null;
            account = StringUtils.isNotBlank((CharSequence)mnsProperties.getAklessRamRoleArn()) ? new CloudAccount(mnsProperties.getEndpoint(), (AlibabaCloudCredentialsProvider)AklessCredProviderFactory.getCredentialsProvider((String)mnsProperties.getAklessRamRoleArn())) : new CloudAccount(mnsProperties.getAccessKeyId(), mnsProperties.getAccessKeySecret(), mnsProperties.getEndpoint());
            this.mnsClient = account.getMNSClient();
        }
        catch (CredProviderException e) {
            throw new TeleportException(TeleportStatusCode.MNS_ERROR, (Throwable)e);
        }
        this.messageClazz = messageClazz;
    }

    @Override
    public int handle() {
        CloudQueue queue = this.mnsClient.getQueueRef(this.mnsProperties.getQueueName());
        try {
            List messages = queue.batchPopMessage(15);
            if (messages == null) {
                return 0;
            }
            for (Message message : messages) {
                if (message == null) continue;
                String originalMessageBody = message.getOriginalMessageBody();
                String realMessageBody = new String(Base64.getDecoder().decode(originalMessageBody));
                JSONObject object = JSONObject.parseObject((String)realMessageBody);
                T callbackMessage = this.parseContext(object, this.messageClazz);
                if (callbackMessage == null) {
                    queue.deleteMessage(message.getReceiptHandle());
                    return -1;
                }
                if (!this.preAccept()) continue;
                log.info("[MNS] accept message:{}", callbackMessage);
                queue.deleteMessage(message.getReceiptHandle());
                this.accept(callbackMessage);
            }
            return messages.size();
        }
        catch (Throwable e) {
            String code = e.getMessage();
            if (!(code != null && code.contains("QueueNotExist") || code != null && code.contains("MessageNotExist"))) {
                throw new TeleportException(TeleportStatusCode.MNS_ERROR, e);
            }
            return 0;
        }
    }

    protected T parseContext(JSONObject object, Class<T> msgClazz) {
        if (object == null) {
            log.warn("[MNS] message is null");
            return null;
        }
        JSONArray events = object.getJSONArray("events");
        if (events == null || events.isEmpty()) {
            log.warn("[MNS] events is empty");
            return null;
        }
        try (OssClient ossClient = new OssClient(this.ossProperties);){
            JSONObject event = events.getJSONObject(0);
            JSONObject ossEvent = event.getJSONObject("oss");
            JSONObject obj = ossEvent.getJSONObject("object");
            String objName = obj.getString("key");
            String messageContent = ossClient.simpleReadText(objName, "inner user");
            if (StringUtils.isBlank((CharSequence)messageContent)) {
                log.warn("[MNS] oss file content is empty, bucket={}, obj={}", (Object)this.ossProperties.getBucket(), (Object)objName);
                T t = null;
                return t;
            }
            Object object2 = JSONObject.parseObject((String)messageContent, msgClazz);
            return (T)object2;
        }
    }

    public MNSClient getMnsClient() {
        return this.mnsClient;
    }

    public MnsProperties getMnsProperties() {
        return this.mnsProperties;
    }

    public SinkProperties getOssProperties() {
        return this.ossProperties;
    }

    public Class<T> getMessageClazz() {
        return this.messageClazz;
    }
}

