/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.entity;

import com.aliyun.migration.teleport.cloud.entity.SinkProperties;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.dto.agent.cmd.StartMetaDiscoveryCmd;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.migration.teleport.common.utils.PasswordUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class MetaProfilingCmd
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StartMetaDiscoveryCmd cmd;
    private String userId;
    private SinkProperties sinkProperties;
    private Integer maxPoolSize = 10;
    private Integer corePoolSize = 10;
    private Map<String, String> properties;
    @Nullable
    private String contextUrl;

    public void encryptDatasource() {
        try {
            if (this.cmd != null && this.cmd.getDatasource() != null && this.cmd.getDatasource().getProperties() != null) {
                this.cmd.getDatasource().setProperties(this.encrypt(this.cmd.getDatasource().getProperties()));
            }
        }
        catch (Exception e) {
            throw new TeleportException(TeleportStatusCode.ENCRYPT_ERROR);
        }
    }

    public void decryptDatasource() {
        try {
            if (this.cmd != null && this.cmd.getDatasource() != null && this.cmd.getDatasource().getProperties() != null) {
                this.cmd.getDatasource().setProperties(this.decrypt(this.cmd.getDatasource().getProperties()));
            }
        }
        catch (Exception e) {
            throw new TeleportException(TeleportStatusCode.ENCRYPT_ERROR);
        }
    }

    private Map<String, String> encrypt(Map<String, String> config) {
        HashMap<String, String> encryptConfig = new HashMap<String, String>();
        if (config == null || config.isEmpty()) {
            return encryptConfig;
        }
        String iv = config.getOrDefault("encryptIv", PasswordUtil.getSecretKeyBase64());
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (PasswordUtil.isPasswordKey((String)key)) {
                PasswordUtil.EncryptEntity entity = PasswordUtil.encryptWithAes256((String)value, (String)iv);
                encryptConfig.put(key, entity.getEncryptContent());
                encryptConfig.put("encryptIv", entity.getEncryptIv());
                continue;
            }
            encryptConfig.put(key, value);
        }
        return encryptConfig;
    }

    private Map<String, String> decrypt(Map<String, String> config) {
        HashMap<String, String> decryptConfig = new HashMap<String, String>();
        if (config == null || config.isEmpty()) {
            return decryptConfig;
        }
        String iv = config.get("encryptIv");
        if (!StringUtils.hasText((String)iv)) {
            return config;
        }
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (PasswordUtil.isPasswordKey((String)key)) {
                String content = PasswordUtil.decryptWithAes256((String)value, (String)iv);
                decryptConfig.put(key, content);
                continue;
            }
            decryptConfig.put(key, value);
        }
        return decryptConfig;
    }

    public void validate() {
        if (!StringUtils.hasText((String)this.userId)) {
            throw new TeleportException(TeleportStatusCode.PARAM_LACK_ERROR, "userId is null");
        }
        if (this.sinkProperties == null) {
            throw new TeleportException(TeleportStatusCode.PARAM_LACK_ERROR, "sinkProperties is null");
        }
        this.sinkProperties.validate();
        if (this.cmd == null) {
            throw new TeleportException(TeleportStatusCode.PARAM_LACK_ERROR, "startMetaDiscoveryCmd is null");
        }
        if (this.cmd.getDatasource() == null) {
            throw new TeleportException(TeleportStatusCode.PARAM_LACK_ERROR, "dataSource is null");
        }
        if (this.cmd.getMetaVersion() == null) {
            throw new TeleportException(TeleportStatusCode.PARAM_LACK_ERROR, "metaVersion is null");
        }
    }

    public StartMetaDiscoveryCmd getCmd() {
        return this.cmd;
    }

    public String getUserId() {
        return this.userId;
    }

    public SinkProperties getSinkProperties() {
        return this.sinkProperties;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Integer getCorePoolSize() {
        return this.corePoolSize;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Nullable
    public String getContextUrl() {
        return this.contextUrl;
    }

    public void setCmd(StartMetaDiscoveryCmd cmd) {
        this.cmd = cmd;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setSinkProperties(SinkProperties sinkProperties) {
        this.sinkProperties = sinkProperties;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setCorePoolSize(Integer corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setContextUrl(@Nullable String contextUrl) {
        this.contextUrl = contextUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaProfilingCmd)) {
            return false;
        }
        MetaProfilingCmd other = (MetaProfilingCmd)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxPoolSize = this.getMaxPoolSize();
        Integer other$maxPoolSize = other.getMaxPoolSize();
        if (this$maxPoolSize == null ? other$maxPoolSize != null : !((Object)this$maxPoolSize).equals(other$maxPoolSize)) {
            return false;
        }
        Integer this$corePoolSize = this.getCorePoolSize();
        Integer other$corePoolSize = other.getCorePoolSize();
        if (this$corePoolSize == null ? other$corePoolSize != null : !((Object)this$corePoolSize).equals(other$corePoolSize)) {
            return false;
        }
        StartMetaDiscoveryCmd this$cmd = this.getCmd();
        StartMetaDiscoveryCmd other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        SinkProperties this$sinkProperties = this.getSinkProperties();
        SinkProperties other$sinkProperties = other.getSinkProperties();
        if (this$sinkProperties == null ? other$sinkProperties != null : !((Object)this$sinkProperties).equals(other$sinkProperties)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$contextUrl = this.getContextUrl();
        String other$contextUrl = other.getContextUrl();
        return !(this$contextUrl == null ? other$contextUrl != null : !this$contextUrl.equals(other$contextUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaProfilingCmd;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxPoolSize = this.getMaxPoolSize();
        result = result * 59 + ($maxPoolSize == null ? 43 : ((Object)$maxPoolSize).hashCode());
        Integer $corePoolSize = this.getCorePoolSize();
        result = result * 59 + ($corePoolSize == null ? 43 : ((Object)$corePoolSize).hashCode());
        StartMetaDiscoveryCmd $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        SinkProperties $sinkProperties = this.getSinkProperties();
        result = result * 59 + ($sinkProperties == null ? 43 : ((Object)$sinkProperties).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $contextUrl = this.getContextUrl();
        result = result * 59 + ($contextUrl == null ? 43 : $contextUrl.hashCode());
        return result;
    }

    public String toString() {
        return "MetaProfilingCmd(cmd=" + this.getCmd() + ", userId=" + this.getUserId() + ", sinkProperties=" + this.getSinkProperties() + ", maxPoolSize=" + this.getMaxPoolSize() + ", corePoolSize=" + this.getCorePoolSize() + ", properties=" + this.getProperties() + ", contextUrl=" + this.getContextUrl() + ")";
    }
}

