/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.dataworks;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks_public20240518.Client;
import com.aliyun.dataworks_public20240518.models.CreateDIJobRequest;
import com.aliyun.dataworks_public20240518.models.CreateDIJobResponse;
import com.aliyun.dataworks_public20240518.models.CreateNodeRequest;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponse;
import com.aliyun.dataworks_public20240518.models.CreateNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.CreatePipelineRunRequest;
import com.aliyun.dataworks_public20240518.models.CreatePipelineRunResponse;
import com.aliyun.dataworks_public20240518.models.CreateResourceRequest;
import com.aliyun.dataworks_public20240518.models.CreateResourceResponse;
import com.aliyun.dataworks_public20240518.models.DeleteNodeRequest;
import com.aliyun.dataworks_public20240518.models.DeleteNodeResponse;
import com.aliyun.dataworks_public20240518.models.DeleteNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.ExecPipelineRunStageRequest;
import com.aliyun.dataworks_public20240518.models.ExecPipelineRunStageResponse;
import com.aliyun.dataworks_public20240518.models.ExecuteAdhocWorkflowInstanceRequest;
import com.aliyun.dataworks_public20240518.models.ExecuteAdhocWorkflowInstanceResponse;
import com.aliyun.dataworks_public20240518.models.ExecuteAdhocWorkflowInstanceResponseBody;
import com.aliyun.dataworks_public20240518.models.GetNodeRequest;
import com.aliyun.dataworks_public20240518.models.GetNodeResponse;
import com.aliyun.dataworks_public20240518.models.GetNodeResponseBody;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunRequest;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunResponse;
import com.aliyun.dataworks_public20240518.models.GetPipelineRunResponseBody;
import com.aliyun.dataworks_public20240518.models.GetProjectRequest;
import com.aliyun.dataworks_public20240518.models.GetProjectResponse;
import com.aliyun.dataworks_public20240518.models.GetProjectResponseBody;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogRequest;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogResponse;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceLogResponseBody;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceRequest;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceResponse;
import com.aliyun.dataworks_public20240518.models.GetTaskInstanceResponseBody;
import com.aliyun.dataworks_public20240518.models.GetTaskRequest;
import com.aliyun.dataworks_public20240518.models.GetTaskResponse;
import com.aliyun.dataworks_public20240518.models.GetTaskResponseBody;
import com.aliyun.dataworks_public20240518.models.ListResourcesRequest;
import com.aliyun.dataworks_public20240518.models.ListResourcesResponse;
import com.aliyun.dataworks_public20240518.models.ListResourcesResponseBody;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesRequest;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesResponse;
import com.aliyun.dataworks_public20240518.models.ListTaskInstancesResponseBody;
import com.aliyun.dataworks_public20240518.models.ListTasksRequest;
import com.aliyun.dataworks_public20240518.models.ListTasksResponse;
import com.aliyun.dataworks_public20240518.models.ListTasksResponseBody;
import com.aliyun.dataworks_public20240518.models.StartDIJobRequest;
import com.aliyun.dataworks_public20240518.models.StartDIJobResponse;
import com.aliyun.dataworks_public20240518.models.StopWorkflowInstancesRequest;
import com.aliyun.dataworks_public20240518.models.StopWorkflowInstancesResponse;
import com.aliyun.dataworks_public20240518.models.StopWorkflowInstancesResponseBody;
import com.aliyun.dataworks_public20240518.models.SuccessInfoValue;
import com.aliyun.migration.teleport.cloud.entity.BrokerProperties;
import com.aliyun.migration.teleport.cloud.entity.DataWorksAdhocTask;
import com.aliyun.migration.teleport.cloud.enums.CloudAccessType;
import com.aliyun.migration.teleport.cloud.enums.TaskNodeType;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;

public class DataWorksClient {
    private static final Logger log = LoggerFactory.getLogger(DataWorksClient.class);
    private final Client client;
    public static final String MANUAL_TASK = "DataworksManualTask";
    public static final String MANUAL_TRIGGER_TYPE = "Manual";
    public static final String DEFAULT_CU = "1";
    public static final Long DELAYED_TIME_MS = 500L;

    public DataWorksClient(BrokerProperties properties) {
        try {
            String endpoint = properties.getEndpoint();
            if (!org.springframework.util.StringUtils.hasText((String)endpoint)) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_CLIENT_ERROR, "DataWorks endpoint is empty");
            }
            Config config = new Config().setAccessKeyId(properties.getAccessKeyId()).setAccessKeySecret(properties.getAccessKeySecret()).setEndpoint(properties.getEndpoint());
            if (properties.getLoginType() == CloudAccessType.STS) {
                config.setSecurityToken(properties.getSecurityToken());
            }
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_CLIENT_ERROR);
        }
    }

    public Long createNode(Long projectId, String nodeSpec) {
        CreateNodeRequest createNodeRequest = new CreateNodeRequest().setProjectId(projectId).setScene(MANUAL_TASK).setSpec(nodeSpec);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            CreateNodeResponse response = this.client.createNodeWithOptions(createNodeRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "CreateNode");
            }
            CreateNodeResponseBody body = response.getBody();
            log.info("[DataWorks] CreateNodeResponseBody:{}", (Object)body);
            return body.getId();
        }
        catch (Exception error) {
            log.error("[DataWorks] CreateNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetNodeResponseBody.GetNodeResponseBodyNode getNode(Long projectId, Long nodeId) {
        GetNodeRequest getNodeRequest = new GetNodeRequest().setProjectId(projectId).setId(nodeId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetNodeResponse response = this.client.getNodeWithOptions(getNodeRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "GetNodeRequest");
            }
            GetNodeResponseBody body = response.getBody();
            log.info("[DataWorks] GetNode:{}", (Object)body);
            return body.getNode();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public Boolean deleteNode(Long projectId, Long nodeId) {
        DeleteNodeRequest deleteNodeRequest = new DeleteNodeRequest().setProjectId(projectId).setId(nodeId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            DeleteNodeResponse response = this.client.deleteNodeWithOptions(deleteNodeRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "DeleteNode");
            }
            DeleteNodeResponseBody body = response.getBody();
            log.info("[DataWorks] DeleteNode:{}", (Object)body);
            return body.getSuccess();
        }
        catch (Exception error) {
            log.error("[DataWorks] DeleteNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetTaskResponseBody.GetTaskResponseBodyTask getTask(Long taskId) {
        GetTaskRequest getTaskRequest = new GetTaskRequest().setId(taskId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetTaskResponse response = this.client.getTaskWithOptions(getTaskRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "GetTask");
            }
            GetTaskResponseBody body = response.getBody();
            log.info("[DataWorks] GetTask:{}", (Object)body);
            return body.getTask();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetTask", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public List<ListTasksResponseBody.ListTasksResponseBodyPagingInfoTasks> listTasks(Long projectId, String taskName, String resourceGroupId) {
        ListTasksRequest listTasksRequest = new ListTasksRequest().setProjectId(projectId).setTaskType(TaskNodeType.SHELL.getType()).setTriggerType(MANUAL_TRIGGER_TYPE).setRuntimeResource(resourceGroupId).setName(taskName);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ListTasksResponse response = this.client.listTasksWithOptions(listTasksRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "ListTasks");
            }
            ListTasksResponseBody body = response.getBody();
            return body.getPagingInfo().getTasks();
        }
        catch (Exception error) {
            log.error("[DataWorks] DeleteNode", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public Long execMultiAdhocTask(Long projectId, String owner, String workflowName, List<DataWorksAdhocTask> adhocTasks, Long bizDate) {
        List<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks> tasks = this.buildTasks(adhocTasks);
        ExecuteAdhocWorkflowInstanceRequest executeAdhocWorkflowInstanceRequest = new ExecuteAdhocWorkflowInstanceRequest().setTasks(tasks).setName(workflowName).setProjectId(projectId).setOwner(owner).setBizDate(bizDate);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ExecuteAdhocWorkflowInstanceResponse response = this.client.executeAdhocWorkflowInstanceWithOptions(executeAdhocWorkflowInstanceRequest, runtime);
            ExecuteAdhocWorkflowInstanceResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "ExecAdhocTask");
            }
            log.info("[DataWorks] ExecAdhocTask: projectId={}, bizDate={}, workflowInstanceId={}", new Object[]{projectId, bizDate, body.getWorkflowInstanceId()});
            for (DataWorksAdhocTask adhocTask : adhocTasks) {
                adhocTask.setWorkflowInstanceId(body.getWorkflowInstanceId());
            }
            return body.getWorkflowInstanceId();
        }
        catch (Exception error) {
            log.error("[DataWorks] ExecAdhocTask", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    private List<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks> buildTasks(List<DataWorksAdhocTask> adhocTasks) {
        ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks> buf = new ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks>();
        for (DataWorksAdhocTask adhocTask : adhocTasks) {
            ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksScript script = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksScript().setContent(adhocTask.getScript());
            ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksRuntimeResource runtimeResource = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksRuntimeResource().setResourceGroupId(adhocTask.getResourceGroupId()).setImage(adhocTask.getImage()).setCu(org.springframework.util.StringUtils.hasText((String)adhocTask.getCu()) ? adhocTask.getCu() : DEFAULT_CU);
            ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks task = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasks().setClientUniqueCode(adhocTask.getTaskUid()).setName(adhocTask.getTaskName()).setType(adhocTask.getNodeType() == null ? TaskNodeType.SHELL.getType() : adhocTask.getNodeType().getType()).setOwner(adhocTask.getOwner()).setRuntimeResource(runtimeResource).setScript(script);
            if (adhocTask.getOutputs() != null && !adhocTask.getOutputs().isEmpty()) {
                ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputs outputs = new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputs();
                ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputsTaskOutputs> taskOutputs = new ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputsTaskOutputs>();
                for (String output : adhocTask.getOutputs()) {
                    taskOutputs.add(new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksOutputsTaskOutputs().setOutput(output));
                }
                outputs.setTaskOutputs(taskOutputs);
                task.setOutputs(outputs);
            }
            if (adhocTask.getDependencies() != null && !adhocTask.getDependencies().isEmpty()) {
                ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksDependencies> dependencies = new ArrayList<ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksDependencies>();
                for (String dependency : adhocTask.getDependencies()) {
                    dependencies.add(new ExecuteAdhocWorkflowInstanceRequest.ExecuteAdhocWorkflowInstanceRequestTasksDependencies().setUpstreamOutput(dependency));
                }
                task.setDependencies(dependencies);
            }
            buf.add(task);
        }
        return buf;
    }

    public Map<String, SuccessInfoValue> stopWorkflowInstance(List<Long> workflowInstanceIdList) {
        StopWorkflowInstancesRequest stopWorkflowInstancesRequest = new StopWorkflowInstancesRequest().setIds(workflowInstanceIdList);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            StopWorkflowInstancesResponse response = this.client.stopWorkflowInstancesWithOptions(stopWorkflowInstancesRequest, runtime);
            StopWorkflowInstancesResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "StopWorkflowInstances");
            }
            return body.getSuccessInfo();
        }
        catch (Exception error) {
            log.error("[DataWorks] StopWorkflowInstances", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public ListTaskInstancesResponseBody.ListTaskInstancesResponseBodyPagingInfoTaskInstances getTaskInstance(Long projectId, Long bizDate, Long workflowInstanceId, String taskName) {
        ListTaskInstancesRequest listTaskInstancesRequest = new ListTaskInstancesRequest().setProjectId(projectId).setBizdate(bizDate).setWorkflowInstanceId(workflowInstanceId);
        if (org.springframework.util.StringUtils.hasText((String)taskName)) {
            listTaskInstancesRequest.setTaskName(taskName);
        }
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            ListTaskInstancesResponse response = this.client.listTaskInstancesWithOptions(listTaskInstancesRequest, runtime);
            ListTaskInstancesResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "ListTaskInstances");
            }
            List taskInstances = body.getPagingInfo().getTaskInstances();
            if (CollectionUtils.isEmpty((Collection)taskInstances)) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "DataWorks task instance is empty");
            }
            log.info("[DataWorks] ListTaskInstances:{}", (Object)body);
            return (ListTaskInstancesResponseBody.ListTaskInstancesResponseBodyPagingInfoTaskInstances)taskInstances.get(0);
        }
        catch (Exception error) {
            log.error("[DataWorks] ListTaskInstances", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetTaskInstanceResponseBody.GetTaskInstanceResponseBodyTaskInstance getTaskInstance(Long taskInstanceId) {
        GetTaskInstanceRequest getTaskInstanceRequest = new GetTaskInstanceRequest().setId(taskInstanceId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetTaskInstanceResponse response = this.client.getTaskInstanceWithOptions(getTaskInstanceRequest, runtime);
            GetTaskInstanceResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "GetTaskInstance");
            }
            log.info("[DataWorks] GetTaskInstance: instanceId={}", (Object)body.getTaskInstance().getId());
            return body.getTaskInstance();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetTaskInstance", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public String getTaskInstanceLog(Long taskInstanceId) {
        log.info("[DataWorks] get task instance log, taskId={}", (Object)taskInstanceId);
        GetTaskInstanceLogRequest getTaskInstanceLogRequest = new GetTaskInstanceLogRequest().setId(taskInstanceId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetTaskInstanceLogResponse response = this.client.getTaskInstanceLogWithOptions(getTaskInstanceLogRequest, runtime);
            GetTaskInstanceLogResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "GetTaskInstanceLog");
            }
            return body.getTaskInstanceLog();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetTaskInstanceLog", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public GetProjectResponseBody.GetProjectResponseBodyProject getProject(Long projectId) {
        GetProjectRequest getProjectRequest = new GetProjectRequest().setId(projectId);
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            GetProjectResponse response = this.client.getProjectWithOptions(getProjectRequest, runtime);
            if (HttpStatus.OK.value() != response.getStatusCode().intValue()) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, "GetProject");
            }
            GetProjectResponseBody body = response.getBody();
            if (body == null) {
                throw new TeleportException(TeleportStatusCode.DATA_WORKS_RESPONSE_BODY_EMPTY, "GetProject");
            }
            return body.getProject();
        }
        catch (Exception error) {
            log.error("[DataWorks] GetProject", (Throwable)error);
            throw new TeleportException(TeleportStatusCode.DATA_WORKS_REQUEST_ERROR, (Throwable)error);
        }
    }

    public String getSparkJarSpec(String jarName) {
        return String.format("{\n    \"version\": \"1.1.0\",\n    \"kind\": \"Resource\",\n    \"spec\": {\n        \"fileResources\": [\n            {\n                \"name\": \"%s\",\n                \"script\": {\n                    \"path\": \"%s\",\n                    \"runtime\": {\n                        \"command\": \"ODPS_JAR\"\n                    }\n                },\n                \"type\": \"jar\"\n            }\n        ]\n    }\n}\n", jarName, jarName);
    }

    public void uploadSparkJar(Long projectId, String jarName, String ossPath) throws Exception {
        this.uploadResource(projectId, this.getSparkJarSpec(jarName), ossPath);
    }

    public void uploadResource(Long projectId, String resourceSpec, String ossPath) throws Exception {
        Long resourceId = this.createResource(projectId, resourceSpec, ossPath);
        PipeLineStatus pipeLineStatus = this.onlineResource(projectId, resourceId);
        if (pipeLineStatus != PipeLineStatus.Success) {
            throw new TeleportException(TeleportStatusCode.HTTP_REQUEST_ERROR, String.format("Upload resource %s failed", ossPath));
        }
    }

    private Long createResource(Long projectId, String resourceSpec, String ossPath) throws Exception {
        CreateResourceRequest createResourceRequest = new CreateResourceRequest().setProjectId(projectId).setSpec(resourceSpec).setResourceFile(ossPath);
        CreateResourceResponse response = this.client.createResource(createResourceRequest);
        return response.getBody().getId();
    }

    public boolean existsResource(Long projectId, String resourceName) throws Exception {
        ListResourcesRequest request = new ListResourcesRequest().setType("Jar").setPageSize(Integer.valueOf(100)).setProjectId(projectId);
        ListResourcesResponse listResourcesResponse = this.client.listResources(request);
        ListResourcesResponseBody listResourcesResponseBody = listResourcesResponse.getBody();
        ListResourcesResponseBody.ListResourcesResponseBodyPagingInfo pagingInfo = listResourcesResponseBody.getPagingInfo();
        return pagingInfo.resources.stream().anyMatch(resource -> resource.name.equals(resourceName));
    }

    private PipeLineStatus onlineResource(Long projectId, Long resourceId) throws Exception {
        String pipelineId = this.createOnlinePipelineRun(projectId, List.of(resourceId.toString()));
        Integer onlineStep = 1;
        block0: while (true) {
            GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipeline pipelineStatus;
            if ((pipelineStatus = this.delayedRun(() -> this.getPipelineRun(this.client, projectId, pipelineId))).getStatus().equals(PipeLineStatus.Running.name())) {
                GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipelineStages stage2;
                boolean thisStageFinish = false;
                for (GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipelineStages stage2 : pipelineStatus.getStages()) {
                    if (!stage2.getStep().equals(onlineStep) || !stage2.getStatus().equals(PipeLineStatus.Success.name())) continue;
                    thisStageFinish = true;
                    break;
                }
                if (!thisStageFinish) continue;
                Iterator iterator = onlineStep;
                onlineStep = onlineStep + 1;
                iterator = pipelineStatus.getStages().iterator();
                do {
                    if (!iterator.hasNext()) continue block0;
                } while (!(stage2 = (GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipelineStages)iterator.next()).getStep().equals(onlineStep) || !stage2.getStatus().equals(PipeLineStatus.Init.name()));
                this.delayedRun(() -> this.execPipelineRunStage(this.client, projectId, pipelineId, stage2.getCode()));
                continue;
            }
            if (pipelineStatus.getStatus().equals(PipeLineStatus.Success.name())) {
                return PipeLineStatus.Success;
            }
            if (pipelineStatus.getStatus().equals(PipeLineStatus.Fail.name())) {
                return PipeLineStatus.Fail;
            }
            if (pipelineStatus.getStatus().equals(PipeLineStatus.Termination.name())) {
                return PipeLineStatus.Termination;
            }
            if (pipelineStatus.getStatus().equals(PipeLineStatus.Cancel.name())) break;
        }
        return PipeLineStatus.Cancel;
    }

    private GetPipelineRunResponseBody.GetPipelineRunResponseBodyPipeline getPipelineRun(Client client, Long projectId, String pipelineId) throws Exception {
        GetPipelineRunRequest request = new GetPipelineRunRequest().setProjectId(projectId).setId(pipelineId);
        GetPipelineRunResponse response = client.getPipelineRun(request);
        return response.getBody().getPipeline();
    }

    public boolean execPipelineRunStage(Client client, Long projectId, String id, String code) throws Exception {
        ExecPipelineRunStageRequest request = new ExecPipelineRunStageRequest().setProjectId(projectId).setId(id).setCode(code);
        ExecPipelineRunStageResponse response = client.execPipelineRunStage(request);
        return response.getBody().getSuccess();
    }

    private String createOnlinePipelineRun(Long projectId, List<String> objectIds) throws Exception {
        CreatePipelineRunRequest request = new CreatePipelineRunRequest().setProjectId(projectId).setObjectIds(objectIds).setType("Online");
        CreatePipelineRunResponse response = this.client.createPipelineRun(request);
        return response.getBody().getId();
    }

    public long doCreateDiJob(Long projectId, String sourceDataSourceType, String destinationDataSourceType, String resourceGroupId, String jobType, String jobName, List<String> sourcePaths, Map<String, String> runtimeConfig) throws Exception {
        CreateDIJobRequest createDIJobRequest = new CreateDIJobRequest();
        createDIJobRequest.setProjectId(projectId);
        createDIJobRequest.setJobName(jobName);
        if (StringUtils.isEmpty((CharSequence)jobType)) {
            jobType = "FileCopy";
        }
        createDIJobRequest.setMigrationType(jobType);
        createDIJobRequest.setSourceDataSourceType(sourceDataSourceType);
        createDIJobRequest.setDestinationDataSourceType(destinationDataSourceType);
        CreateDIJobRequest.CreateDIJobRequestSourceDataSourceSettings srcDatasourceSetting = new CreateDIJobRequest.CreateDIJobRequestSourceDataSourceSettings();
        srcDatasourceSetting.setDataSourceName("mock");
        HashMap props = new HashMap();
        srcDatasourceSetting.setDataSourceProperties(CreateDIJobRequest.CreateDIJobRequestSourceDataSourceSettingsDataSourceProperties.build(props));
        createDIJobRequest.setSourceDataSourceSettings(Arrays.asList(srcDatasourceSetting));
        CreateDIJobRequest.CreateDIJobRequestDestinationDataSourceSettings dstDatasourceSettings = new CreateDIJobRequest.CreateDIJobRequestDestinationDataSourceSettings();
        dstDatasourceSettings.setDataSourceName("mock");
        createDIJobRequest.setDestinationDataSourceSettings(Arrays.asList(dstDatasourceSettings));
        CreateDIJobRequest.CreateDIJobRequestResourceSettings resourceSettings = new CreateDIJobRequest.CreateDIJobRequestResourceSettings();
        CreateDIJobRequest.CreateDIJobRequestResourceSettingsScheduleResourceSettings schedulerResourceSettings = new CreateDIJobRequest.CreateDIJobRequestResourceSettingsScheduleResourceSettings();
        schedulerResourceSettings.setResourceGroupIdentifier(resourceGroupId);
        resourceSettings.setScheduleResourceSettings(schedulerResourceSettings);
        createDIJobRequest.setResourceSettings(resourceSettings);
        ArrayList<Object> mappings = new ArrayList<Object>();
        for (String eachPath : sourcePaths) {
            CreateDIJobRequest.CreateDIJobRequestTableMappings mapping = new CreateDIJobRequest.CreateDIJobRequestTableMappings();
            ArrayList<CreateDIJobRequest.CreateDIJobRequestTableMappingsSourceObjectSelectionRules> sourceRules = new ArrayList<CreateDIJobRequest.CreateDIJobRequestTableMappingsSourceObjectSelectionRules>();
            CreateDIJobRequest.CreateDIJobRequestTableMappingsSourceObjectSelectionRules sourceRule = new CreateDIJobRequest.CreateDIJobRequestTableMappingsSourceObjectSelectionRules();
            sourceRule.setObjectType("FILE");
            sourceRule.setExpression(eachPath);
            sourceRules.add(sourceRule);
            mapping.setSourceObjectSelectionRules(sourceRules);
            mappings.add(mapping);
        }
        createDIJobRequest.setTableMappings(mappings);
        CreateDIJobRequest.CreateDIJobRequestJobSettings jobSetting = new CreateDIJobRequest.CreateDIJobRequestJobSettings();
        ArrayList<CreateDIJobRequest.CreateDIJobRequestJobSettingsRuntimeSettings> runtimeSettings = new ArrayList<CreateDIJobRequest.CreateDIJobRequestJobSettingsRuntimeSettings>();
        jobSetting.setRuntimeSettings(runtimeSettings);
        for (String key : runtimeConfig.keySet()) {
            String value = runtimeConfig.get(key);
            CreateDIJobRequest.CreateDIJobRequestJobSettingsRuntimeSettings runtimeSetting = new CreateDIJobRequest.CreateDIJobRequestJobSettingsRuntimeSettings();
            runtimeSetting.setName(key);
            runtimeSetting.setValue(value);
            runtimeSettings.add(runtimeSetting);
        }
        createDIJobRequest.setJobSettings(jobSetting);
        CreateDIJobResponse createDIJobResponse = this.client.createDIJob(createDIJobRequest);
        log.info("create job finished, response job id is " + createDIJobResponse.getBody().getDIJobId());
        log.info("create job finished, response is {}", (Object)JSONObject.toJSONString((Object)createDIJobResponse.getBody(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        return createDIJobResponse.getBody().getDIJobId();
    }

    public void startDIJob(long jobId) throws Exception {
        StartDIJobRequest startDIJobRequest = new StartDIJobRequest();
        startDIJobRequest.setDIJobId(Long.valueOf(jobId));
        StartDIJobResponse response = this.client.startDIJob(startDIJobRequest);
        log.info("Start DI job with body:{}", (Object)JSON.toJSONString((Object)response.getBody()));
    }

    private void pauseForAMount() {
        try {
            Thread.sleep(DELAYED_TIME_MS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private <T> T delayedRun(DelayedRunnable<T> runnable) {
        try {
            this.pauseForAMount();
            return runnable.call();
        }
        catch (Exception e) {
            log.error("Error occurred while running delayed task: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static enum PipeLineStatus {
        Init,
        Running,
        Success,
        Fail,
        Termination,
        Cancel;

    }

    @FunctionalInterface
    static interface DelayedRunnable<T> {
        public T call() throws Exception;
    }
}

