/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util.matcher;

import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;

public class WildcardStringMatcher
implements StringMatcher {
    private String expression;

    public WildcardStringMatcher(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean matches(String text) {
        if (this.expression == text) {
            return true;
        }
        if (this.validate(this.expression, text)) {
            return false;
        }
        int i = 0;
        int j = 0;
        int starIndex = -1;
        int iIndex = -1;
        while (i < text.length()) {
            if (j < this.expression.length() && (this.expression.charAt(j) == '?' || this.expression.charAt(j) == text.charAt(i))) {
                ++i;
                ++j;
                continue;
            }
            if (j < this.expression.length() && this.expression.charAt(j) == '*') {
                starIndex = j++;
                iIndex = i;
                continue;
            }
            if (starIndex != -1) {
                j = starIndex + 1;
                i = iIndex + 1;
                ++iIndex;
                continue;
            }
            return false;
        }
        while (j < this.expression.length() && this.expression.charAt(j) == '*') {
            ++j;
        }
        return j == this.expression.length();
    }

    @Override
    public void clear() {
        this.expression = null;
    }

    private boolean validate(String expression, String text) {
        return expression == null && text != null || expression != null && text == null;
    }
}

