/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util.matcher;

import com.aliyun.securitysdk.rass.util.matcher.SetBasedStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.trie.SimpleTrieNode;
import com.aliyun.securitysdk.rass.util.matcher.trie.Trie;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.HostLetterTrieNodeConverter;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.TrieNodeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TrieStringMatcher
extends SetBasedStringMatcher
implements StringMatcher {
    private volatile Trie trie;
    private final TrieNodeConverter converter;
    private final boolean prefix;

    public TrieStringMatcher() {
        this(null, new HostLetterTrieNodeConverter(), true);
    }

    public TrieStringMatcher(TrieNodeConverter converter) {
        this(null, converter, true);
    }

    public TrieStringMatcher(TrieNodeConverter converter, boolean prefix) {
        this(null, converter, prefix);
    }

    public TrieStringMatcher(Collection<String> collection, TrieNodeConverter converter, boolean prefix) {
        super(collection);
        this.converter = converter;
        this.prefix = prefix;
        this.trie = this.buildTrie(this.SET);
    }

    @Override
    public boolean matches(String text) {
        return this.trie.search(text);
    }

    @Override
    public SetBasedStringMatcher addItem(String item) {
        super.addItem(item);
        this.trie = this.buildTrie(this.SET);
        return this;
    }

    @Override
    public SetBasedStringMatcher addItems(Collection<String> collection) {
        super.addItems(collection);
        this.trie = this.buildTrie(this.SET);
        return this;
    }

    @Override
    public SetBasedStringMatcher removeItem(String item) {
        super.removeItem(item);
        this.trie = this.buildTrie(this.SET);
        return this;
    }

    @Override
    public SetBasedStringMatcher removeItems(Collection<String> items) {
        super.removeItems(items);
        this.trie = this.buildTrie(this.SET);
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.trie = new SimpleTrieNode(null, this.converter, this.prefix);
    }

    private Trie buildTrie(Collection<String> collection) {
        SimpleTrieNode trie = new SimpleTrieNode(null, this.converter, this.prefix);
        if (collection instanceof List) {
            trie.build((List)collection);
        } else {
            trie.build(new ArrayList<String>(collection));
        }
        return trie;
    }

    public Trie getTrie() {
        return this.trie;
    }
}

