/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util;

public class StackTraceUtils {
    private static int MAX_STACK_TRACE_LENGTH = 80;

    public static StackTraceElement[] filterFrames(StackTraceElement[] stacks) {
        String className;
        int i = 0;
        for (i = 1; i < stacks.length && ((className = stacks[i].getClassName()).startsWith("com.aliyun.securitysdk.rass") || className.startsWith("java.lang.Thread")); ++i) {
        }
        if (i == 1) {
            return stacks;
        }
        int newLength = stacks.length - i;
        StackTraceElement[] result = new StackTraceElement[Math.min(MAX_STACK_TRACE_LENGTH, newLength)];
        if (newLength > MAX_STACK_TRACE_LENGTH) {
            System.arraycopy(stacks, i, result, 0, MAX_STACK_TRACE_LENGTH);
        } else {
            System.arraycopy(stacks, i, result, 0, newLength);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stackTraceAsString(StackTraceElement[] stackTraceElements) {
        StackTraceElement[] stacks = StackTraceUtils.filterFrames(stackTraceElements);
        String result = "";
        for (StackTraceElement stack : stacks) {
            try {
                result = result + stack.getClassName() + "." + stack.getMethodName() + "(" + stack.getFileName();
                result = result + ":" + stack.getLineNumber() + ")";
            }
            catch (Throwable throwable) {
            }
            finally {
                result = result + "\n";
            }
        }
        return result;
    }
}

