/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.util;

import com.aliyun.securitysdk.rass.util.ClassUtils;

public abstract class LogVersionUtil {
    public static final String LOG4J_INDICATOR_CLASS = "org.apache.log4j.Logger";
    public static final String LOG4J2_INDICATOR_CLASS = "org.apache.logging.log4j.Logger";
    public static final String LOG4J2_CORE_INDICATOR_CLASS = "org.apache.logging.log4j.core.Logger";
    public static final String LOGBACK_INDICATOR_CLASS = "ch.qos.logback.classic.Logger";
    public static boolean IS_LOG4J_PRESENTS = LogVersionUtil.detectFromClasspath("org.apache.log4j.Logger");
    public static boolean IS_LOG4J2_PRESENTS = LogVersionUtil.detectFromClasspath("org.apache.logging.log4j.Logger");
    public static boolean IS_LOG4J2_CORE_PRESENTS = LogVersionUtil.detectFromClasspath("org.apache.logging.log4j.core.Logger");
    public static boolean IS_LOG4J2_GT_2171 = LogVersionUtil.detectLog4jVersion();
    public static boolean IS_LOGBACK_PRESENTS = LogVersionUtil.detectFromClasspath("ch.qos.logback.classic.Logger");

    public static boolean detectFromClasspath(String classpath) {
        return ClassUtils.isPresent(classpath, null);
    }

    public static boolean detectLog4jVersion() {
        Class<?> log4j;
        try {
            log4j = ClassUtils.forNameQuietly(LOG4J2_CORE_INDICATOR_CLASS, ClassUtils.getDefaultClassLoader());
        }
        catch (Throwable e) {
            return false;
        }
        if (log4j == null) {
            return false;
        }
        String version = log4j.getPackage().getSpecificationVersion();
        if (version == null) {
            return false;
        }
        if (!version.startsWith("2.")) {
            return false;
        }
        String[] versionParts = version.split("\\.");
        try {
            int minorVersion = Integer.parseInt(versionParts[1]);
            if (minorVersion <= 16) {
                return false;
            }
            if (minorVersion == 17) {
                if (versionParts.length < 3) {
                    return false;
                }
                int revision = Integer.parseInt(versionParts[2]);
                return revision >= 1;
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

