/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.transformer;

import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.config.schema.Serialization;
import com.aliyun.securitysdk.rass.filter.EnhancedObjectInputFilter;
import com.aliyun.securitysdk.rass.permission.checker.SerializationPermissionChecker;
import com.aliyun.securitysdk.rass.resolver.transformer.BasePermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.matcher.SetBasedStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.TrieStringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.BasicTrieNodeConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Serialization2SerializationPermissionCheckerTransformer
extends BasePermissionCheckerTransformer {
    public List<SerializationPermissionChecker> transform(Serialization serialization) {
        ArrayList<SerializationPermissionChecker> resultCheckers = new ArrayList<SerializationPermissionChecker>();
        for (Serialization.PermChecker permChecker : serialization.getPermChecker()) {
            if (!permChecker.isEnabled()) continue;
            Action[] actions = this.getActions(permChecker);
            PatternResolver resolver = new PatternResolver(permChecker, actions);
            SerializationPermissionChecker serializationPermissionChecker = resolver.resolve();
            serializationPermissionChecker.setShouldCheckStackMatcher(this.resolveStack(permChecker.getEnabledStackMatchers()));
            serializationPermissionChecker.setAllowedStackMatcher(this.resolveStack(permChecker.getAllowStackMatchers()));
            serializationPermissionChecker.setDisallowedStackMatcher(this.resolveStack(permChecker.getDisallowStackMatchers()));
            resultCheckers.add(serializationPermissionChecker);
        }
        return resultCheckers;
    }

    public static class PatternResolver {
        private Serialization.PermChecker permChecker;
        private Action[] actions;
        private Set<String> limitedPatterns;
        private Set<String> allowedTriePatterns = new HashSet<String>();
        private Set<String> disallowedTriePatterns = new HashSet<String>();
        private Set<Class<?>> allowedClasses = new HashSet();
        private Set<Class<?>> disallowedClasses = new HashSet();

        public PatternResolver(Serialization.PermChecker permChecker, Action[] actions) {
            this.limitedPatterns = new HashSet<String>();
            this.permChecker = permChecker;
            this.actions = actions;
        }

        public SerializationPermissionChecker resolve() {
            for (String serializePattern : this.permChecker.getSerializePatternList().getSerializePattern()) {
                if (serializePattern.length() == 0) continue;
                if (this.isLimit(serializePattern)) {
                    this.limitedPatterns.add(serializePattern);
                    continue;
                }
                boolean negative = serializePattern.startsWith("!");
                if (negative) {
                    serializePattern = serializePattern.substring(1);
                }
                if (serializePattern.endsWith(":enabledSubclass") || serializePattern.endsWith(":enabledSubclass=true")) {
                    this.parseSerializePattern(negative, serializePattern);
                    continue;
                }
                this.parseFormalSerializePattern(negative, serializePattern);
            }
            SetBasedStringMatcher allowedMatcher = new TrieStringMatcher(new BasicTrieNodeConverter(), true).addItems(this.allowedTriePatterns);
            SetBasedStringMatcher disallowedMatcher = new TrieStringMatcher(new BasicTrieNodeConverter(), true).addItems(this.disallowedTriePatterns);
            SerializationPermissionChecker checker = new SerializationPermissionChecker(this.limitedPatterns, allowedMatcher, disallowedMatcher, this.allowedClasses, this.disallowedClasses, PermissionMode.toMode((String)this.permChecker.getMode().value()), this.permChecker.isEnabled(), this.actions);
            return checker;
        }

        private boolean isLimit(String pattern) {
            int eqNdx = pattern.indexOf(61);
            return eqNdx >= 0;
        }

        private void parseSerializePattern(boolean negative, String serializePattern) {
            String classname = serializePattern.substring(0, serializePattern.indexOf(58));
            Class<?> clazz = ClassUtils.forNameQuietly(classname, EnhancedObjectInputFilter.class.getClassLoader());
            if (clazz == null) {
                return;
            }
            if (negative) {
                this.disallowedClasses.add(clazz);
            } else {
                this.allowedClasses.add(clazz);
            }
        }

        private void parseFormalSerializePattern(boolean negative, String serializePattern) {
            int len = serializePattern.length();
            if (serializePattern.endsWith("*")) {
                if (serializePattern.endsWith(".**")) {
                    serializePattern = serializePattern.substring(0, len - 1);
                }
            } else {
                Class<?> clazz;
                if (serializePattern.endsWith(":oisonly")) {
                    serializePattern = serializePattern.substring(0, len - 8);
                }
                if ((clazz = ClassUtils.forNameQuietly(serializePattern, EnhancedObjectInputFilter.class.getClassLoader())) == null) {
                    return;
                }
            }
            if (negative) {
                this.disallowedTriePatterns.add(serializePattern);
            } else {
                this.allowedTriePatterns.add(serializePattern);
            }
        }
    }
}

