/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.transformer;

import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.util.OsUtils;
import com.aliyun.securitysdk.rass.config.schema.File;
import com.aliyun.securitysdk.rass.config.schema.FileMatchableList;
import com.aliyun.securitysdk.rass.permission.checker.FilePermissionChecker;
import com.aliyun.securitysdk.rass.resolver.Matchable2StringMatcherFactory;
import com.aliyun.securitysdk.rass.resolver.transformer.BasePermissionCheckerTransformer;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import com.aliyun.securitysdk.rass.util.matcher.trie.converter.BasicTrieNodeConverter;
import java.util.ArrayList;
import java.util.List;

public class File2FilePermissionCheckerTransformer
extends BasePermissionCheckerTransformer {
    public List<FilePermissionChecker> transform(File file) {
        ArrayList<FilePermissionChecker> resultCheckers = new ArrayList<FilePermissionChecker>();
        for (File.PermChecker permChecker : file.getPermChecker()) {
            if (!permChecker.isEnabled()) continue;
            ArrayList<FileMatchableList.FileMatcher> matchables = new ArrayList<FileMatchableList.FileMatcher>();
            List<File.PermChecker.AllowedFileList> allowedFileList = permChecker.getAllowedFileList();
            for (FileMatchableList fileMatchableList : allowedFileList) {
                File2FilePermissionCheckerTransformer.resolveFilePatterns(fileMatchableList);
                matchables.addAll(fileMatchableList.getFileMatcher());
            }
            StringMatcher stringMatcher = Matchable2StringMatcherFactory.toStringMatcher(matchables, new BasicTrieNodeConverter(), true);
            ArrayList<FileMatchableList.FileMatcher> arrayList = new ArrayList<FileMatchableList.FileMatcher>();
            List<File.PermChecker.DisallowedFileList> disallowedFileList = permChecker.getDisallowedFileList();
            for (FileMatchableList fileMatchableList : disallowedFileList) {
                File2FilePermissionCheckerTransformer.resolveFilePatterns(fileMatchableList);
                arrayList.addAll(fileMatchableList.getFileMatcher());
            }
            StringMatcher disallowedStringMatcher = Matchable2StringMatcherFactory.toStringMatcher(arrayList, new BasicTrieNodeConverter(), true);
            PermissionMode permissionMode = PermissionMode.toMode((String)permChecker.getMode().value());
            Action[] actions = this.getActions(permChecker);
            FilePermissionChecker filePermissionChecker = new FilePermissionChecker(stringMatcher, disallowedStringMatcher, permissionMode, true, actions);
            filePermissionChecker.setShouldCheckStackMatcher(this.resolveStack(permChecker.getEnabledStackMatchers()));
            filePermissionChecker.setAllowedStackMatcher(this.resolveStack(permChecker.getAllowStackMatchers()));
            filePermissionChecker.setDisallowedStackMatcher(this.resolveStack(permChecker.getDisallowStackMatchers()));
            resultCheckers.add(filePermissionChecker);
        }
        return resultCheckers;
    }

    private static void resolveFilePatterns(FileMatchableList fileList) {
        for (FileMatchableList.FileMatcher matcher : fileList.getFileMatcher()) {
            String pattern = matcher.getPattern();
            if (pattern == null || !pattern.startsWith("~/")) continue;
            pattern = OsUtils.USER_HOME + pattern.substring(2);
            matcher.setPattern(pattern);
        }
    }
}

