/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.formatter.mask;

import com.aliyun.securitysdk.rass.resolver.formatter.mask.MatcherMask;
import java.util.HashMap;
import java.util.Map;

public class DomainMask
implements MatcherMask {
    private static final String DOMAIN_SEPARATOR = "/";
    private final String domainString;
    private MatchType matchType = MatchType.Trie;

    public DomainMask(String domainString) {
        int index = domainString.lastIndexOf(DOMAIN_SEPARATOR);
        if (index != -1) {
            String matchTypeString = domainString.substring(index + 1);
            this.matchType = MatchType.fromTypeValue(matchTypeString);
            this.domainString = domainString.substring(0, index);
        } else {
            this.domainString = domainString;
        }
    }

    @Override
    public String format() {
        return this.domainString;
    }

    public String getDomainString() {
        return this.domainString;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public static enum MatchType {
        Precise("p"),
        Trie("t");

        private String type;
        private static final Map<String, MatchType> stringToEnum;

        private MatchType(String type) {
            this.type = type;
        }

        public static MatchType fromTypeValue(String v) {
            if (v != null && !v.isEmpty() && stringToEnum.containsKey(v)) {
                return stringToEnum.get(v);
            }
            throw new IllegalArgumentException("Cannot resolve string [" + v + "] to match type.");
        }

        static {
            stringToEnum = new HashMap<String, MatchType>();
            for (MatchType item : MatchType.values()) {
                if (stringToEnum.containsKey(item.type)) {
                    throw new IllegalArgumentException("Duplicated enums, the values of enums should be unique : " + item.type);
                }
                stringToEnum.put(item.type, item);
            }
        }
    }
}

