/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.formatter;

import com.aliyun.securitysdk.rass.resolver.formatter.Domain2StringListFormatter;
import com.aliyun.securitysdk.rass.resolver.formatter.Ips2SubnetMasksStringListFormatter;
import com.aliyun.securitysdk.rass.resolver.formatter.Ipv6s2SubnetMaskStringListFormatter;
import com.aliyun.securitysdk.rass.resolver.formatter.StringListFormatter;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.DomainMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.MatcherMask;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.MatcherMasksParsers;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.SubnetMask;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcherEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class StringMatcherParamsFormatters {
    private static StringListFormatter<SubnetMask> string2Ipv6SubnetMaskFormatter = new Ipv6s2SubnetMaskStringListFormatter();
    private static StringListFormatter<SubnetMask> string2SubnetMaskFormatter = new Ips2SubnetMasksStringListFormatter();
    private static StringListFormatter<DomainMask> domainMaskStringListFormatter = new Domain2StringListFormatter();

    public static List<String> format(StringMatcherEnum stringMatcherEnum, Collection<String> masks) {
        if (stringMatcherEnum == null || masks == null) {
            return Collections.emptyList();
        }
        Class<? extends MatcherMask> supportMaskType = stringMatcherEnum.supportMaskType();
        if (supportMaskType.isAssignableFrom(SubnetMask.class)) {
            ArrayList<SubnetMask> subnetMasks = new ArrayList<SubnetMask>();
            for (String mask : masks) {
                subnetMasks.add(MatcherMasksParsers.parse(mask, SubnetMask.class));
            }
            return StringMatcherParamsFormatters.formatSubnetMasks(stringMatcherEnum, subnetMasks);
        }
        ArrayList<DomainMask> domainMasks = new ArrayList<DomainMask>();
        for (String mask : masks) {
            domainMasks.add(MatcherMasksParsers.parse(mask, DomainMask.class));
        }
        return StringMatcherParamsFormatters.formatDomainMasks(domainMasks);
    }

    private static List<String> formatSubnetMasks(StringMatcherEnum stringMatcherEnum, List<SubnetMask> masks) {
        if (stringMatcherEnum == null || masks == null || masks.isEmpty()) {
            return Collections.emptyList();
        }
        if (stringMatcherEnum == StringMatcherEnum.INTRANET_IP || stringMatcherEnum == StringMatcherEnum.ALLOWED_IP) {
            return string2SubnetMaskFormatter.format(masks);
        }
        if (stringMatcherEnum == StringMatcherEnum.INTRANET_IPV6 || stringMatcherEnum == StringMatcherEnum.ALLOWED_IPV6) {
            return string2Ipv6SubnetMaskFormatter.format(masks);
        }
        throw new RuntimeException("Unmatchable " + stringMatcherEnum.value() + " and mask type " + SubnetMask.class);
    }

    private static List<String> formatDomainMasks(List<DomainMask> masks) {
        if (masks == null || masks.isEmpty()) {
            return Collections.emptyList();
        }
        return domainMaskStringListFormatter.format(masks);
    }
}

