/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver.formatter;

import com.aliyun.securitysdk.rass.resolver.formatter.StringListFormatter;
import com.aliyun.securitysdk.rass.resolver.formatter.mask.SubnetMask;
import com.aliyun.securitysdk.rass.util.AssertUtil;
import com.aliyun.securitysdk.rass.util.IpAddressUtil;
import java.util.ArrayList;
import java.util.List;

public class Ipv6s2SubnetMaskStringListFormatter
implements StringListFormatter<SubnetMask> {
    @Override
    public List<String> format(List<SubnetMask> ipv6s) {
        ArrayList<String> toInsertList = new ArrayList<String>();
        for (SubnetMask subnetMask : AssertUtil.notNull(ipv6s, "ips should not be null.")) {
            byte[] ipBytes = IpAddressUtil.textToNumericFormatV6(subnetMask.getAddress());
            if (ipBytes == null) {
                throw new RuntimeException("Failed to parse " + subnetMask);
            }
            String ipAddressBinaryArray = IpAddressUtil.convertIpBytesToString(ipBytes);
            if (subnetMask.getMask() == 128 || subnetMask.getMask() == -1) {
                toInsertList.add(ipAddressBinaryArray);
                continue;
            }
            ipAddressBinaryArray = ipAddressBinaryArray.substring(0, subnetMask.getMask());
            toInsertList.add(ipAddressBinaryArray + '*');
        }
        return toInsertList;
    }
}

