/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.resolver;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.config.schema.RassPolicy;
import com.aliyun.securitysdk.rass.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class PolicyParser {
    private static final Logger logger = SecurityLogManager.getLogger(PolicyParser.class);

    public static RassPolicy parse(InputStream inputStream) {
        AssertUtil.assertNotNull(inputStream, "inputStream should not be null");
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RassPolicy.class});
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(inputStream);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            return (RassPolicy)unmarshaller.unmarshal(xsr);
        }
        catch (JAXBException | XMLStreamException e) {
            logger.warn("parse policy error", e);
            return null;
        }
    }

    public static RassPolicy parse(Path path) {
        AssertUtil.assertNotNull(path, "path should not be null");
        AssertUtil.checkArgument(path.toAbsolutePath().toFile().exists());
        try {
            return PolicyParser.parse(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
            return null;
        }
    }
}

