/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.provider;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.exception.ProvideFailedException;
import com.aliyun.securitysdk.rass.api.provider.InformationProvider;
import com.aliyun.securitysdk.rass.api.util.StringUtils;
import com.aliyun.securitysdk.rass.provider.JdwpInformation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class JwdpInformationProvider
implements InformationProvider<JdwpInformation> {
    private static final Logger logger = SecurityLogManager.getLogger(JwdpInformationProvider.class);
    private static final String JDWP_ADDRESS_PROPERTY = "sun.jdwp.listenerAddress";
    private static final String DEFAULT_NAME = "jdwp information provider";
    private int jdwpListenerPort;
    private String name = "jdwp information provider";

    public JdwpInformation provides() throws ProvideFailedException {
        Integer port = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                if (JwdpInformationProvider.this.jdwpListenerPort == 0) {
                    JwdpInformationProvider.this.jdwpListenerPort = JwdpInformationProvider.readJdwpListenerPort();
                }
                return JwdpInformationProvider.this.jdwpListenerPort;
            }
        });
        JdwpInformation jdwpInformation = new JdwpInformation();
        jdwpInformation.setPort(port);
        return jdwpInformation;
    }

    public Class<JdwpInformation> getTargetClass() {
        return JdwpInformation.class;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static int readJdwpListenerPort() {
        try {
            Class<?> theClass = Class.forName("sun.misc.VMSupport");
            Method m = theClass.getMethod("getAgentProperties", new Class[0]);
            Properties p = (Properties)m.invoke(null, new Object[0]);
            System.out.println(p);
            String listenerAddress = p.getProperty(JDWP_ADDRESS_PROPERTY);
            if (listenerAddress != null) {
                listenerAddress = StringUtils.substringAfter((String)listenerAddress, (String)":");
                return Integer.parseInt(listenerAddress);
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to read sun.jdwp.listenerAddress, ignore");
        }
        return -1;
    }
}

