/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.permission.checker;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.condition.action.SerializationAction;
import com.aliyun.securitysdk.rass.api.ext.GenericCheckResult;
import com.aliyun.securitysdk.rass.permission.SerializationPermission;
import com.aliyun.securitysdk.rass.permission.checker.BasePermissionChecker;
import com.aliyun.securitysdk.rass.util.StackTraceUtils;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import sun.misc.ObjectInputFilter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SerializationPermissionChecker
extends BasePermissionChecker<SerializationPermission> {
    private static final Logger logger = SecurityLogManager.getLogger(SerializationPermissionChecker.class);
    private final Set<String> serializePatterns;
    private Set<Class<?>> allowedClasses;
    private Set<Class<?>> disallowedClasses;
    private StringMatcher allowedMatcher;
    private StringMatcher disallowedMatcher;
    private ObjectInputFilter delegate;

    public SerializationPermissionChecker(Set<String> serializePatterns, StringMatcher allowed, StringMatcher disallowed, Set<Class<?>> allowedClasses, Set<Class<?>> disallowedClasses, PermissionMode permissionMode, boolean enabled, Action ... actions) {
        super(enabled, "serialization checker", permissionMode, actions);
        this.serializePatterns = serializePatterns;
        this.allowedMatcher = allowed;
        this.disallowedMatcher = disallowed;
        this.allowedClasses = allowedClasses;
        this.disallowedClasses = disallowedClasses;
        this.delegate = this.createObjectInputFilter();
    }

    private ObjectInputFilter createObjectInputFilter() {
        StringBuilder builder = new StringBuilder();
        for (String matcher : this.serializePatterns) {
            builder.append(matcher);
            builder.append(";");
        }
        return ObjectInputFilter.Config.createFilter((String)builder.toString());
    }

    private ObjectInputFilter.Status checkInput(SerializationPermission permission) {
        if (permission == null) {
            return ObjectInputFilter.Status.UNDECIDED;
        }
        if (!this.isEnabledStack()) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        if (!this.shouldCheck((Permission)permission)) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        if (this.checkAllowStack()) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        if (this.checkDisallowStack()) {
            return ObjectInputFilter.Status.REJECTED;
        }
        ObjectInputFilter.FilterInfo filterInfo = (ObjectInputFilter.FilterInfo)permission.getResource();
        Class<?> clazz = filterInfo.serialClass();
        if (clazz == null) {
            return ObjectInputFilter.Status.UNDECIDED;
        }
        if (clazz.isArray()) {
            while ((clazz = clazz.getComponentType()).isArray()) {
            }
        }
        if (this.allowedMatcher != null && this.allowedMatcher.matches(clazz.getName())) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        for (Class<?> allowedClass : this.allowedClasses) {
            if (!allowedClass.isAssignableFrom(clazz)) continue;
            return ObjectInputFilter.Status.ALLOWED;
        }
        if (this.disallowedMatcher != null && this.disallowedMatcher.matches(clazz.getName())) {
            return ObjectInputFilter.Status.REJECTED;
        }
        for (Class<?> disallowedClass : this.disallowedClasses) {
            if (!disallowedClass.isAssignableFrom(clazz)) continue;
            return ObjectInputFilter.Status.REJECTED;
        }
        if (this.delegate != null) {
            return this.delegate.checkInput(filterInfo);
        }
        return ObjectInputFilter.Status.UNDECIDED;
    }

    public CheckResult observe(SerializationPermission permission) {
        ObjectInputFilter.Status result = this.checkInput(permission);
        if (result.equals((Object)ObjectInputFilter.Status.REJECTED)) {
            logger.info("[observe] check serialization permission: " + ((ObjectInputFilter.FilterInfo)permission.getResource()).serialClass() + " : rejected");
        }
        return new ObjectInputFilterStatusCheckResult(ObjectInputFilter.Status.ALLOWED);
    }

    public CheckResult handle(SerializationPermission permission) {
        ObjectInputFilter.Status result = this.checkInput(permission);
        if (result.equals((Object)ObjectInputFilter.Status.REJECTED)) {
            logger.info("[block] check serialization permission: " + ((ObjectInputFilter.FilterInfo)permission.getResource()).serialClass() + " : rejected\nStackTrace:\n" + StackTraceUtils.stackTraceAsString(Thread.currentThread().getStackTrace()));
        }
        return new ObjectInputFilterStatusCheckResult(result);
    }

    public List<Action> getDefaultActionList() {
        return Arrays.asList(SerializationAction.All);
    }

    public Set<String> getSerializePatterns() {
        return this.serializePatterns;
    }

    public Set<Class<?>> getAllowedClasses() {
        return this.allowedClasses;
    }

    public Set<Class<?>> getDisallowedClasses() {
        return this.disallowedClasses;
    }

    public StringMatcher getAllowedMatcher() {
        return this.allowedMatcher;
    }

    public StringMatcher getDisallowedMatcher() {
        return this.disallowedMatcher;
    }

    public ObjectInputFilter getDelegate() {
        return this.delegate;
    }

    public void setAllowedClasses(Set<Class<?>> allowedClasses) {
        this.allowedClasses = allowedClasses;
    }

    public void setDisallowedClasses(Set<Class<?>> disallowedClasses) {
        this.disallowedClasses = disallowedClasses;
    }

    public void setAllowedMatcher(StringMatcher allowedMatcher) {
        this.allowedMatcher = allowedMatcher;
    }

    public void setDisallowedMatcher(StringMatcher disallowedMatcher) {
        this.disallowedMatcher = disallowedMatcher;
    }

    public void setDelegate(ObjectInputFilter delegate) {
        this.delegate = delegate;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ObjectInputFilterStatusCheckResult
    extends GenericCheckResult<ObjectInputFilter.Status> {
        private ObjectInputFilterStatusCheckResult(ObjectInputFilter.Status result) {
            super((Object)result, ObjectInputFilter.Status.class);
        }
    }
}

