/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.permission.checker;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.condition.action.CmiAction;
import com.aliyun.securitysdk.rass.api.exception.PermissionException;
import com.aliyun.securitysdk.rass.api.ext.BooleanCheckResult;
import com.aliyun.securitysdk.rass.permission.CmdPermission;
import com.aliyun.securitysdk.rass.permission.checker.BasePermissionChecker;
import com.aliyun.securitysdk.rass.util.StackTraceUtils;
import com.aliyun.securitysdk.rass.util.matcher.StringMatcher;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class CmdPermissionChecker
extends BasePermissionChecker<CmdPermission> {
    private static final Logger logger = SecurityLogManager.getLogger(CmdPermissionChecker.class);
    private final StringMatcher allowedMatcher;
    private final StringMatcher disallowedMatcher;

    public CmdPermissionChecker(StringMatcher allowedMatcher, StringMatcher disallowedMatcher, PermissionMode permissionMode, boolean enabled, Action ... actions) {
        super(enabled, "command checker", permissionMode, actions);
        this.allowedMatcher = allowedMatcher;
        this.disallowedMatcher = disallowedMatcher;
    }

    public boolean checkPermission(CmdPermission permission) {
        if (permission == null) {
            return false;
        }
        String cmd = (String)permission.getResource();
        if (cmd == null || cmd.isEmpty()) {
            return false;
        }
        File f = new File(cmd);
        if (f.exists() && f.isDirectory()) {
            return true;
        }
        if (!this.isEnabledStack()) {
            return true;
        }
        if (!this.shouldCheck((Permission)permission)) {
            return true;
        }
        if (this.checkAllowStack()) {
            return true;
        }
        if (this.checkDisallowStack()) {
            return false;
        }
        int index = cmd.indexOf(32);
        if (index != -1) {
            cmd = cmd.substring(0, index);
        }
        if (cmd.isEmpty()) {
            return false;
        }
        return this.allowedMatcher.matches(cmd) || !this.disallowedMatcher.matches(cmd);
    }

    public CheckResult observe(CmdPermission permission) {
        boolean b = this.checkPermission(permission);
        if (!b) {
            logger.info("[observe] check cmd permission: " + (String)permission.getResource() + " : " + b);
        }
        return BooleanCheckResult.of((boolean)this.checkPermission(permission));
    }

    public CheckResult handle(CmdPermission permission) {
        boolean b = this.checkPermission(permission);
        if (b) {
            return BooleanCheckResult.of((boolean)this.checkPermission(permission));
        }
        logger.info("[block] check cmd permission: " + (String)permission.getResource() + " : " + b + "\nStackTrace:\n" + StackTraceUtils.stackTraceAsString(Thread.currentThread().getStackTrace()));
        throw new PermissionException("The command access of " + (String)permission.getResource() + " has been denied.");
    }

    public List<Action> getDefaultActionList() {
        return Arrays.asList(CmiAction.Execute);
    }
}

