/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.modifier;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.modifier.PropertyModifier;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JndiPropertyModifier
implements PropertyModifier {
    private static final Logger logger = SecurityLogManager.getLogger(JndiPropertyModifier.class);
    private static final String JNDI_REGISTRY_CONTEXT_CLASS_NAME = "com.sun.jndi.rmi.registry.RegistryContext";
    private static final String RMI_URL_CODEBASE_PROPERTY = "com.sun.jndi.rmi.object.trustURLCodebase";
    private static final String JNDI_CNCTX_CLASS_NAME = "com.sun.jndi.cosnaming.CNCtx";
    private static final String COSNAMING_URL_CODEBASE_PROPERTY = "com.sun.jndi.cosnaming.object.trustURLCodebase";
    private static final String JNDI_LDAP_VERSION_HELPER_CLASS_NAME = "com.sun.naming.internal.VersionHelper12";
    private static final String LDAP_URL_CODEBASE_PROPERTY = "com.sun.jndi.ldap.object.trustURLCodebase";
    private static final String TRUST_URL_CODEBASE = "trustURLCodebase";

    @Override
    public void modifyProperty() {
        JndiPropertyModifier.force2DisableJndiTrustURLCodebase();
    }

    private static void force2DisableJndiTrustURLCodebase() {
        JndiPropertyModifier.disableJndiTrustURLCodebase(RMI_URL_CODEBASE_PROPERTY, JNDI_REGISTRY_CONTEXT_CLASS_NAME, "rmi", false);
        JndiPropertyModifier.disableJndiTrustURLCodebase(COSNAMING_URL_CODEBASE_PROPERTY, JNDI_CNCTX_CLASS_NAME, "cosnaming", false);
        JndiPropertyModifier.disableJndiTrustURLCodebase(LDAP_URL_CODEBASE_PROPERTY, JNDI_LDAP_VERSION_HELPER_CLASS_NAME, "ldap", "false");
    }

    private static void disableJndiTrustURLCodebase(final String property, String className, String name, Object target) {
        logger.info("Set {} = false", (Object)property);
        AccessController.doPrivileged(new PrivilegedAction(){

            public String run() {
                return System.setProperty(property, "false");
            }
        });
        Class<?> clazz = ClassUtils.forNameQuietly(className, ClassLoader.getSystemClassLoader());
        if (clazz != null) {
            Field field = ReflectionUtils.findField(clazz, TRUST_URL_CODEBASE);
            if (field != null) {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                try {
                    ReflectionUtils.setFinalField(field, null, target);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                field.setAccessible(isAccessible);
            } else {
                logger.warn("Failed to disable jndi {} trustUrlCodebase.", (Object)name);
            }
        } else {
            logger.warn("Failed to disable jndi {} trustUrlCodebase.", (Object)name);
        }
    }
}

