/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.filter;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.RaptSecurityContext;
import com.aliyun.securitysdk.rass.api.exception.InitializationException;
import com.aliyun.securitysdk.rass.filter.DelegatedRassObjectFilter;
import com.aliyun.securitysdk.rass.filter.DummyRassObjectFilter;
import com.aliyun.securitysdk.rass.filter.EnhancedObjectInputFilter;
import com.aliyun.securitysdk.rass.filter.RassObjectFilter;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import sun.misc.ObjectInputFilter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ObjectInputFilterRegister {
    private static final Logger logger = SecurityLogManager.getLogger(ObjectInputFilterRegister.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RassObjectFilter registerEnhancedObjectInputFilter(RaptSecurityContext raptSecurityContext) {
        String string = "sun.misc.ObjectInputFilter";
        synchronized ("sun.misc.ObjectInputFilter") {
            if (ClassUtils.isObjectInputFilterClassPresent()) {
                EnhancedObjectInputFilter enhancedObjectInputFilter;
                ObjectInputFilter serialFilter = ObjectInputFilter.Config.getSerialFilter();
                if (serialFilter == null) {
                    enhancedObjectInputFilter = new EnhancedObjectInputFilter(raptSecurityContext);
                    ObjectInputFilter.Config.setSerialFilter((ObjectInputFilter)enhancedObjectInputFilter);
                } else if (serialFilter instanceof EnhancedObjectInputFilter) {
                    enhancedObjectInputFilter = (EnhancedObjectInputFilter)serialFilter;
                } else {
                    throw new InitializationException("Failed to add the EnhancedObjectInputFilter since another filter existed.");
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return new DelegatedRassObjectFilter(enhancedObjectInputFilter);
            }
            logger.warn("sun.misc.ObjectInputFilter does not exist, thus the serialization checker won't been registered.");
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return new DummyRassObjectFilter();
        }
    }
}

