/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.filter;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.RaptSecurityContext;
import com.aliyun.securitysdk.rass.permission.SerializationPermission;
import com.aliyun.securitysdk.rass.permission.checker.SerializationPermissionChecker;
import java.util.List;
import sun.misc.ObjectInputFilter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EnhancedObjectInputFilter
implements ObjectInputFilter {
    private static final Logger logger = SecurityLogManager.getLogger(EnhancedObjectInputFilter.class);
    private volatile RaptSecurityContext context;

    public EnhancedObjectInputFilter(RaptSecurityContext context) {
        this.context = context;
    }

    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        CheckResult checkResult;
        List results = this.context.check((Permission)new SerializationPermission(filterInfo));
        if (results == null || results.isEmpty()) {
            return ObjectInputFilter.Status.UNDECIDED;
        }
        if (results.size() > 1) {
            logger.warn("The size of results should not be larger than 1");
        }
        if ((checkResult = (CheckResult)results.iterator().next()) instanceof SerializationPermissionChecker.ObjectInputFilterStatusCheckResult) {
            return (ObjectInputFilter.Status)((SerializationPermissionChecker.ObjectInputFilterStatusCheckResult)checkResult).getResult();
        }
        logger.warn("The type of checkResult is not ObjectInputFilterStatusCheckResult but " + checkResult.getClass().getName());
        return ObjectInputFilter.Status.UNDECIDED;
    }

    public void resetRaptSecurityContext(RaptSecurityContext context) {
        if (context != null) {
            this.context = context;
        }
    }
}

