/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.stack.StackTraceElementProvider;
import com.aliyun.rapt.commons.utils.stack.StackTraceElementProviders;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.RuntimeApplicationSecuritySandbox;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.condition.action.CmiAction;
import com.aliyun.securitysdk.rass.api.condition.action.FileAction;
import com.aliyun.securitysdk.rass.api.config.ConfigLoader;
import com.aliyun.securitysdk.rass.api.config.RassConfig;
import com.aliyun.securitysdk.rass.api.exception.PermissionException;
import com.aliyun.securitysdk.rass.api.exception.RassError;
import com.aliyun.securitysdk.rass.filter.Filters;
import com.aliyun.securitysdk.rass.permission.CmdPermission;
import com.aliyun.securitysdk.rass.permission.FilePermission;
import com.aliyun.securitysdk.rass.util.ClassUtils;
import com.aliyun.securitysdk.rass.util.LogVersionUtil;
import com.aliyun.securitysdk.rass.util.WebApplicationType;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class RassSecurityManager
extends SecurityManager {
    private static final Logger logger = SecurityLogManager.getLogger(RassSecurityManager.class);
    private static final String SUN_UNIX_CHANNEL_FACTORY_NAME = "sun.nio.fs.UnixChannelFactory";
    private SecurityManager delegate = System.getSecurityManager();
    private boolean checkOnlyWhenFileReading = true;
    private RuntimeApplicationSecuritySandbox sandbox;
    private RassConfig rassConfig;

    private static void ClassForNameQuietly(String name, ClassLoader loader) {
        try {
            Class.forName(name, false, loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RassSecurityManager(RuntimeApplicationSecuritySandbox sandbox) {
        this.sandbox = sandbox;
        this.rassConfig = ConfigLoader.loadSecurityConfig();
    }

    private void doCheckExec(String cmd) {
        if (this.sandbox == null || !this.sandbox.getRaptSecurityContext().shouldCheckPermissionWithoutMatcher(CmdPermission.class)) {
            return;
        }
        cmd = Filters.filterCommand(cmd);
        this.sandbox.getRaptSecurityContext().check((Permission)new CmdPermission(cmd, new Action[]{CmiAction.Execute}));
    }

    private void doCheckFileOps(String filepath, Action ... actions) {
        if (this.sandbox == null || !this.sandbox.getRaptSecurityContext().shouldCheckPermissionWithoutMatcher(FilePermission.class)) {
            return;
        }
        this.sandbox.getRaptSecurityContext().check((Permission)new FilePermission(new File(filepath), actions));
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.delegate != null) {
            this.delegate.checkConnect(host, port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        if (this.delegate != null) {
            this.delegate.checkConnect(host, port, context);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.delegate != null) {
            this.delegate.checkListen(port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.delegate != null) {
            this.delegate.checkAccept(host, port);
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        if (this.delegate != null) {
            this.delegate.checkMulticast(maddr);
        }
    }

    @Override
    @Deprecated
    public void checkMulticast(InetAddress maddr, byte ttl) {
        if (this.delegate != null) {
            this.delegate.checkMulticast(maddr, ttl);
        }
    }

    @Override
    public void checkPropertiesAccess() {
        if (this.delegate != null) {
            this.delegate.checkPropertiesAccess();
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (this.delegate != null) {
            this.delegate.checkPropertyAccess(key);
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        if (this.delegate != null) {
            return this.delegate.checkTopLevelWindow(window);
        }
        return true;
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.delegate != null) {
            this.delegate.checkPrintJobAccess();
        }
    }

    public void checkSystemClipboardAccess() {
        if (this.delegate != null) {
            this.delegate.checkSystemClipboardAccess();
        }
    }

    public void checkAwtEventQueueAccess() {
        if (this.delegate != null) {
            this.delegate.checkAwtEventQueueAccess();
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        if (this.delegate != null) {
            this.delegate.checkPackageAccess(pkg);
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.delegate != null) {
            this.delegate.checkPackageDefinition(pkg);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.delegate != null) {
            this.delegate.checkSetFactory();
        }
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
        if (this.delegate != null) {
            this.delegate.checkMemberAccess(clazz, which);
        }
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (this.delegate != null) {
            this.delegate.checkSecurityAccess(target);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        if (this.delegate != null) {
            return this.delegate.getThreadGroup();
        }
        return super.getThreadGroup();
    }

    @Override
    public void checkPermission(java.security.Permission perm) {
        String permissionName = AccessController.doPrivileged(new GetPermissionNameAction(perm));
        if (permissionName != null && permissionName.equals("setSecurityManager")) {
            throw new PermissionException("You don't have permission to set SecurityManager");
        }
        if (this.delegate != null) {
            this.delegate.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(java.security.Permission perm, Object context) {
        if (this.delegate != null) {
            this.delegate.checkPermission(perm, context);
        }
    }

    @Override
    public void checkCreateClassLoader() {
        if (this.delegate != null) {
            this.delegate.checkCreateClassLoader();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        if (this.delegate != null) {
            this.delegate.checkAccess(t);
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (this.delegate != null) {
            this.delegate.checkAccess(g);
        }
    }

    @Override
    public void checkExit(int status) {
        if (this.delegate != null) {
            this.delegate.checkExit(status);
        }
    }

    @Override
    public void checkExec(String cmd) {
        this.doCheckExec(cmd);
        if (this.delegate != null) {
            this.delegate.checkExec(cmd);
        }
    }

    @Override
    public void checkLink(String lib) {
        logger.info("RASS observed that java is loading library: [{}] (no blocking, just observation)", (Object)lib);
        if (this.delegate != null) {
            this.delegate.checkLink(lib);
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.delegate != null) {
            this.delegate.checkRead(fd);
        }
    }

    @Override
    public void checkRead(String file) {
        block8: {
            if (this.sandbox == null || !this.sandbox.getRaptSecurityContext().shouldCheckPermissionWithoutMatcher(FilePermission.class)) {
                return;
            }
            if (file.endsWith(".class") || file.endsWith(".jar") || file.endsWith(".war")) {
                if (LogVersionUtil.IS_LOG4J2_PRESENTS && LogVersionUtil.IS_LOG4J2_CORE_PRESENTS && !LogVersionUtil.IS_LOG4J2_GT_2171 && file.endsWith("org/apache/logging/log4j/core/net/JndiManager.class") && WebApplicationType.CURRENT_TYPE != WebApplicationType.NONE) {
                    if (!this.getRassConfig().isIgnoreLog4jWarning()) {
                        throw new RassError("JNDI of log4j2 would not be allowed.");
                    }
                    logger.warn("JNDI of log4j2 would not be allowed.");
                }
                return;
            }
            try {
                this.doCheckFileOps(file, new Action[]{FileAction.Read});
            }
            catch (PermissionException e) {
                if (!this.checkOnlyWhenFileReading) {
                    throw e;
                }
                StackTraceElementProvider provider = StackTraceElementProviders.of();
                if (provider.getStackTraceDepth() <= 4) break block8;
                String className = provider.getStackTraceElement(4).getClassName();
                if (!FileInputStream.class.getName().equals(className) && !SUN_UNIX_CHANNEL_FACTORY_NAME.equals(className)) break block8;
                throw e;
            }
        }
        if (this.delegate != null) {
            this.delegate.checkRead(file);
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        this.doCheckFileOps(file, new Action[]{FileAction.Read});
        if (this.delegate != null) {
            this.delegate.checkRead(file, context);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
        if (this.delegate != null) {
            this.delegate.checkWrite(fd);
        }
    }

    @Override
    public void checkWrite(String file) {
        this.doCheckFileOps(file, new Action[]{FileAction.Write});
        if (this.delegate != null) {
            this.delegate.checkWrite(file);
        }
    }

    @Override
    public void checkDelete(String file) {
        this.doCheckFileOps(file, new Action[]{FileAction.Delete});
        if (this.delegate != null) {
            this.delegate.checkDelete(file);
        }
    }

    @Override
    public Object getSecurityContext() {
        if (this.delegate != null) {
            return this.delegate.getSecurityContext();
        }
        return null;
    }

    public SecurityManager getDelegate() {
        return this.delegate;
    }

    public void setCheckOnlyWhenFileReading(boolean checkOnlyWhenFileReading) {
        this.checkOnlyWhenFileReading = checkOnlyWhenFileReading;
    }

    public RuntimeApplicationSecuritySandbox getSandbox() {
        return this.sandbox;
    }

    public RassConfig getRassConfig() {
        return this.rassConfig;
    }

    static {
        StackTraceElementProviders.initialize();
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        RassSecurityManager.ClassForNameQuietly("com.aliyun.securitysdk.rass.RassSecurityManager.GetPermissionNameAction", classLoader);
        RassSecurityManager.ClassForNameQuietly("com.aliyun.securitysdk.rass.RassSecurityManager$GetPermissionNameAction", classLoader);
        RassSecurityManager.ClassForNameQuietly("com.aliyun.securitysdk.rass.permission.FilePermission", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.lang.ClassLoader$1", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.lang.ClassLoader$2", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.lang.RuntimePermission", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.net.SocketPermission", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.net.NetPermission", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.security.AccessController", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.security.PrivilegedAction", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.security.Permission", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.security.BasicPermission", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.security.SecurityPermission", classLoader);
        RassSecurityManager.ClassForNameQuietly("java.security.AllPermission", classLoader);
    }

    static class GetPermissionNameAction
    implements PrivilegedAction<String> {
        private final java.security.Permission perm;

        GetPermissionNameAction(java.security.Permission perm) {
            this.perm = perm;
        }

        @Override
        public String run() {
            return this.perm.getName();
        }
    }
}

