/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.utils.stack;

import com.aliyun.rapt.commons.utils.exception.RaptCommonRuntimeException;
import com.aliyun.rapt.commons.utils.stack.StackTraceElementProvider;
import com.aliyun.rapt.commons.utils.stack.StackTraceElementProviderFactory;
import java.util.ServiceLoader;

public abstract class StackTraceElementProviders {
    private static StackTraceElementProviderFactory STACK_TRACE_ELEMENT_PROVIDER_FACTORY;
    private static volatile boolean isInit;

    public static void initialize() {
        if (!isInit) {
            for (StackTraceElementProviderFactory factory : ServiceLoader.load(StackTraceElementProviderFactory.class, StackTraceElementProviders.class.getClassLoader())) {
                if (factory.support()) {
                    STACK_TRACE_ELEMENT_PROVIDER_FACTORY = factory;
                    break;
                }
                if (STACK_TRACE_ELEMENT_PROVIDER_FACTORY == null) continue;
                break;
            }
            if (STACK_TRACE_ELEMENT_PROVIDER_FACTORY == null) {
                throw new RaptCommonRuntimeException("Cannot support stack trace provides.");
            }
            isInit = true;
        }
    }

    public static StackTraceElementProvider of() {
        StackTraceElementProviders.initialize();
        return STACK_TRACE_ELEMENT_PROVIDER_FACTORY.create();
    }

    public static StackTraceElementProvider of(boolean lazy) {
        StackTraceElementProviders.initialize();
        return STACK_TRACE_ELEMENT_PROVIDER_FACTORY.create(lazy);
    }

    static {
        isInit = false;
    }
}

