/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.handle;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks_public20200518.models.GetBusinessResponseBody;
import com.aliyun.dataworks_public20200518.models.GetFileResponseBody;
import com.aliyun.dataworks_public20200518.models.GetProjectResponseBody;
import com.aliyun.dataworks_public20200518.models.ListDataSourcesResponseBody;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowTrigger;
import com.aliyun.migration.workflow.migration.dw.tool.DwTaskReaderTool;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwOpenApiHandler {
    private static final Logger log = LoggerFactory.getLogger(DwOpenApiHandler.class);
    private DwTaskReaderTool dwTaskReaderTool;
    private String projectId;
    protected Datasource scheduleDataSource;
    protected TaskContext taskContext;

    public DwOpenApiHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        this.scheduleDataSource = scheduleDataSource;
        this.taskContext = taskContext;
    }

    public void init() {
        Map properties = this.scheduleDataSource.getProperties();
        this.dwTaskReaderTool = new DwTaskReaderTool(properties);
        String project = (String)properties.get("project");
        try {
            this.projectId = Integer.toString(this.dwTaskReaderTool.getProjectDetailByName(project).getProjectId());
        }
        catch (InterruptedException e) {
            this.projectId = null;
            log.error("\u627e\u4e0d\u5230\u540d\u4e3a{}\u7684\u5de5\u4f5c\u7a7a\u95f4", (Object)project);
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.WORKFLOW_PACKAGE_NOT_FOUND);
        }
    }

    public DwOpenApiHandler(String endpoint, String accessKeyId, String accessKeySecret, String projectIdStr) {
        this.init(endpoint, accessKeyId, accessKeySecret, projectIdStr);
    }

    private void init(String endpoint, String accessKeyId, String accessKeySecret, String projectIdStr) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("endpoint", endpoint);
        properties.put("ak", accessKeyId);
        properties.put("sk", accessKeySecret);
        this.projectId = projectIdStr;
        this.dwTaskReaderTool = new DwTaskReaderTool(properties);
    }

    public WorkflowProjectPackage read() {
        GetProjectResponseBody.GetProjectResponseBodyData projectData = this.dwTaskReaderTool.getProjectDetailById(this.projectId);
        List<GetBusinessResponseBody.GetBusinessResponseBodyData> businessList = this.dwTaskReaderTool.getBusinessDetailList(this.projectId);
        List<GetFileResponseBody.GetFileResponseBodyData> nodeList = this.dwTaskReaderTool.getWorkflowNodeDetailList(this.projectId);
        List<ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources> dataSourceList = this.dwTaskReaderTool.getDatasourceList(this.projectId);
        HashMap<String, String> folderList = new HashMap<String, String>();
        WorkflowProjectPackage workflowProjectPackage = this.convert(projectData, businessList, nodeList, folderList, dataSourceList);
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }

    private WorkflowProjectPackage convert(GetProjectResponseBody.GetProjectResponseBodyData projectData, List<GetBusinessResponseBody.GetBusinessResponseBodyData> businessList, List<GetFileResponseBody.GetFileResponseBodyData> nodeList, Map<String, String> folderList, List<ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources> dataSourceList) {
        if (businessList == null) {
            log.error("\u5de5\u4f5c\u7a7a\u95f4\u5185\u65e0\u4e1a\u52a1\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\u53c2\u6570");
            return null;
        }
        if (nodeList == null) {
            nodeList = new ArrayList<GetFileResponseBody.GetFileResponseBodyData>();
        }
        WorkflowProjectPackage workflowProjectPackage = new WorkflowProjectPackage();
        workflowProjectPackage.setWorkflowProject(new WorkflowProject());
        workflowProjectPackage.setWorkflowList(new ArrayList());
        workflowProjectPackage.setDatasources(new ArrayList());
        HashMap<String, Workflow> workflowMap = new HashMap<String, Workflow>();
        this.projectConvert(workflowProjectPackage.getWorkflowProject(), projectData);
        this.workflowListConvert(workflowProjectPackage.getWorkflowList(), workflowMap, businessList);
        this.fileListConvert(nodeList, workflowMap, folderList);
        this.nodeRelationConvert(workflowProjectPackage);
        this.datasourceConvert(workflowProjectPackage.getDatasources(), dataSourceList);
        return workflowProjectPackage;
    }

    private void projectConvert(WorkflowProject project, GetProjectResponseBody.GetProjectResponseBodyData projectData) {
        if (projectData == null) {
            return;
        }
        project.setProjectId(projectData.getProjectId().toString());
        project.setId(projectData.getTenantId());
        project.setName(projectData.getProjectName());
        project.setDescription(projectData.getProjectDescription());
    }

    private void workflowListConvert(List<Workflow> workflowList, Map<String, Workflow> workflowMap, List<GetBusinessResponseBody.GetBusinessResponseBodyData> businessList) {
        if (workflowMap == null) {
            workflowMap = new HashMap<String, Workflow>();
        }
        for (GetBusinessResponseBody.GetBusinessResponseBodyData business : businessList) {
            Workflow workflow = this.workflowConvert(business);
            workflowMap.put(workflow.getWorkflowId(), workflow);
            workflowList.add(workflow);
        }
    }

    private Workflow workflowConvert(GetBusinessResponseBody.GetBusinessResponseBodyData business) {
        Workflow workflow = new Workflow();
        workflow.setWorkflowId(business.getBusinessId().toString());
        workflow.setWorkflowName(business.getBusinessName());
        workflow.setDescription(business.getDescription());
        workflow.setOwner(business.getOwner());
        workflow.setProjectId(business.getProjectId().toString());
        workflow.setCustomProperties(new HashMap());
        workflow.getCustomProperties().put("useType", business.getUseType());
        workflow.setWorkflowNodes(new ArrayList());
        workflow.setFiles(new ArrayList());
        workflow.setFunctions(new ArrayList());
        return workflow;
    }

    private void fileListConvert(List<GetFileResponseBody.GetFileResponseBodyData> files, Map<String, Workflow> workflowMap, Map<String, String> folderList) {
        if (files == null) {
            return;
        }
        for (GetFileResponseBody.GetFileResponseBodyData file : files) {
            LabelType type = CodeProgramType.getNodeTypeByCode((int)file.getFile().getFileType()).getLabelType();
            if (type == null || type.equals((Object)LabelType.DATA_PROCESS)) {
                this.workflowNodeConvert(file, workflowMap, folderList);
                continue;
            }
            switch (type) {
                case FUNCTION: {
                    this.functionResourceConvert(file, workflowMap, folderList);
                    break;
                }
                case RESOURCE: {
                    this.fileResourceConvert(file, workflowMap, folderList);
                    break;
                }
            }
        }
    }

    private void workflowNodeConvert(GetFileResponseBody.GetFileResponseBodyData file, Map<String, Workflow> workflowMap, Map<String, String> folderList) {
        WorkflowNode workflowNode = new WorkflowNode();
        if (file.getFile().getBusinessId() == -1L) {
            log.warn("\u53d1\u73b0\u4e34\u65f6\u67e5\u8be2\uff1a{}\uff0c\u8df3\u8fc7", (Object)file.getFile().getFileName());
            return;
        }
        Workflow workflow = workflowMap.get(file.getFile().getBusinessId().toString());
        workflow.getWorkflowNodes().add(workflowNode);
        workflowNode.setWorkflowId(workflow.getWorkflowId());
        workflowNode.setWorkflowName(workflow.getWorkflowName());
        workflowNode.setNodeId(file.getFile().getFileId().toString());
        workflowNode.setNodeName(file.getFile().getFileName());
        workflowNode.setNodeType(CodeProgramType.getNodeTypeByCode((int)file.getFile().getFileType()).getName());
        workflowNode.setOwner(file.getFile().getOwner());
        workflowNode.setDescription(file.getFile().getFileDescription());
        workflowNode.setParamMap(new HashMap());
        if (file.getNodeConfiguration().getParaValue().contains("=")) {
            Arrays.stream(file.getNodeConfiguration().getParaValue().split(" ")).toList().forEach(x -> {
                if (x.split("=").length == 2) {
                    workflowNode.getParamMap().put(x.split("=")[0], x.split("=")[1]);
                } else if (x.split("=").length == 1) {
                    workflowNode.getParamMap().put(x.split("=")[0], "");
                }
            });
        }
        WorkflowTrigger trigger = new WorkflowTrigger();
        trigger.setWorkflowId(workflow.getWorkflowId());
        trigger.setWorkflowName(workflow.getWorkflowName());
        trigger.setCron(file.getNodeConfiguration().getCronExpress());
        trigger.setStartTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(file.getNodeConfiguration().getStartEffectDate()), ZoneId.systemDefault()));
        trigger.setEndTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(file.getNodeConfiguration().getEndEffectDate()), ZoneId.systemDefault()));
        trigger.setTimezone(ZoneId.systemDefault());
        trigger.setType(file.getNodeConfiguration().getSchedulerType());
        workflowNode.setTrigger(trigger);
        workflowNode.setCustomProperties(new HashMap());
        if (folderList.containsKey(file.getFile().getFileFolderId())) {
            workflowNode.getCustomProperties().put("folderPath", folderList.get(file.getFile().getFileFolderId()));
        } else {
            String folderPath = this.dwTaskReaderTool.getFolderPathById(this.projectId, file.getFile().getFileFolderId());
            folderList.put(file.getFile().getFileFolderId(), folderPath);
            workflowNode.getCustomProperties().put("folderPath", folderPath);
        }
        ArrayList inputNameList = new ArrayList();
        file.getNodeConfiguration().getInputList().forEach(x -> inputNameList.add(x.getInput()));
        ArrayList outputNameList = new ArrayList();
        file.getNodeConfiguration().getOutputList().forEach(x -> outputNameList.add(x.getOutput()));
        workflowNode.getCustomProperties().put("inputNameList", inputNameList);
        workflowNode.getCustomProperties().put("outputNameList", outputNameList);
        workflowNode.getCustomProperties().put("orgData", JSONObject.toJSONString((Object)file, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
    }

    private WorkflowFileResource fileResourceConvert(GetFileResponseBody.GetFileResponseBodyData file, Map<String, Workflow> workflowMap, Map<String, String> folderList) {
        WorkflowFileResource workflowFileResource = new WorkflowFileResource();
        Workflow workflow = workflowMap.get(file.getFile().getBusinessId().toString());
        workflow.getFiles().add(workflowFileResource);
        workflowFileResource.setId(file.getFile().getFileId().toString());
        workflowFileResource.setFileId(file.getFile().getFileId().toString());
        workflowFileResource.setName(file.getFile().getFileName());
        workflowFileResource.setFileType(CodeProgramType.getNodeTypeByCode((int)file.getFile().getFileType()).getName());
        workflowFileResource.setFolder(folderList.get(file.getFile().getFileFolderId()));
        if (folderList.containsKey(file.getFile().getFileFolderId())) {
            workflowFileResource.setFolder(folderList.get(file.getFile().getFileFolderId()));
        } else {
            String folderPath = this.dwTaskReaderTool.getFolderPathById(this.projectId, file.getFile().getFileFolderId());
            folderList.put(file.getFile().getFileFolderId(), folderPath);
            workflowFileResource.setFolder(folderPath);
        }
        workflowFileResource.setDescription(file.getFile().getContent());
        return workflowFileResource;
    }

    private WorkflowFunctionResource functionResourceConvert(GetFileResponseBody.GetFileResponseBodyData file, Map<String, Workflow> workflowMap, Map<String, String> folderList) {
        WorkflowFunctionResource workflowFunctionResource = new WorkflowFunctionResource();
        Workflow workflow = workflowMap.get(file.getFile().getBusinessId().toString());
        workflow.getFunctions().add(workflowFunctionResource);
        workflowFunctionResource.setId(file.getFile().getFileId().toString());
        workflowFunctionResource.setFunctionId(file.getFile().getFileId().toString());
        workflowFunctionResource.setName(file.getFile().getFileName());
        workflowFunctionResource.setType(CodeProgramType.getNodeTypeByCode((int)file.getFile().getFileType()).getName());
        JSONObject content = JSONObject.parseObject((String)file.getFile().getContent());
        workflowFunctionResource.setClassName(content.getString("className"));
        workflowFunctionResource.setFunctionType(WorkflowFunctionResource.FunctionType.valueOf((String)content.getString("functionType")));
        workflowFunctionResource.setUsageDescription(content.getString("description"));
        workflowFunctionResource.setArgumentsDescription(content.getString("cmdDesc") + "\n" + content.getString("paramDesc"));
        workflowFunctionResource.setReturnValueDescription(content.getString("returnValue"));
        workflowFunctionResource.setUsageExample(content.getString("example"));
        workflowFunctionResource.setRuntimeResource(content.getString("resources"));
        workflowFunctionResource.setCustomProperties(new HashMap());
        if (folderList.containsKey(file.getFile().getFileFolderId())) {
            workflowFunctionResource.getCustomProperties().put("folderPath", folderList.get(file.getFile().getFileFolderId()));
        } else {
            String folderPath = this.dwTaskReaderTool.getFolderPathById(this.projectId, file.getFile().getFileFolderId());
            folderList.put(file.getFile().getFileFolderId(), folderPath);
            workflowFunctionResource.getCustomProperties().put("folderPath", folderPath);
        }
        return workflowFunctionResource;
    }

    private void nodeRelationConvert(WorkflowProjectPackage workflowProjectPackage) {
        if (workflowProjectPackage.getWorkflowList() == null) {
            return;
        }
        HashMap nodeOutputMap = new HashMap();
        workflowProjectPackage.getWorkflowList().forEach(workflow -> workflow.getWorkflowNodes().forEach(workflowNode -> {
            List outputNameList = (List)workflowNode.getCustomProperties().get("outputNameList");
            if (outputNameList != null) {
                for (String outputName : outputNameList) {
                    nodeOutputMap.put(outputName, workflowNode.getNodeId());
                }
            }
        }));
        workflowProjectPackage.getWorkflowList().forEach(workflow -> {
            workflow.setNodeRelations(new ArrayList());
            workflow.getWorkflowNodes().forEach(workflowNode -> {
                List inputNameList = (List)workflowNode.getCustomProperties().get("inputNameList");
                if (inputNameList != null) {
                    for (String inputName : inputNameList) {
                        if (nodeOutputMap.containsKey(inputName)) {
                            RelationPackage relationPackage = RelationPackage.builder().from((String)nodeOutputMap.get(inputName)).to(workflowNode.getNodeId()).reType(RelationPackage.ReType.NODE).build();
                            workflow.getNodeRelations().add(relationPackage);
                            continue;
                        }
                        if (inputName.equals(workflowProjectPackage.getWorkflowProject().getName() + "_root")) continue;
                        RelationPackage relationPackage = RelationPackage.builder().from(inputName).to(workflowNode.getNodeId()).reType(RelationPackage.ReType.NODE).build();
                    }
                }
            });
        });
    }

    private void datasourceConvert(List<WorkflowDatasource> datasources, List<ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources> dataSourceList) {
        if (dataSourceList == null) {
            return;
        }
        for (ListDataSourcesResponseBody.ListDataSourcesResponseBodyDataDataSources ds : dataSourceList) {
            WorkflowDatasource datasource = new WorkflowDatasource();
            datasource.setDatasourceId(Long.toString(ds.getId()));
            datasource.setName(ds.getName());
            datasource.setCustomProperties(new HashMap());
            if (ds.getStatus() == 1) {
                datasource.getCustomProperties().put("status", Datasource.ConnectionStatus.SUCCESS);
            } else {
                datasource.getCustomProperties().put("status", Datasource.ConnectionStatus.NOT_CONNECT);
            }
            switch (ds.getDataSourceType()) {
                case "odps": {
                    datasource.setType(Datasource.Type.MaxCompute.name());
                    break;
                }
                case "mysql": {
                    datasource.setType(Datasource.Type.MySQL.name());
                    break;
                }
                case "rds": {
                    datasource.setType(Datasource.Type.Custom.name());
                    break;
                }
                case "oss": {
                    datasource.setType(Datasource.Type.HDFS.name());
                    break;
                }
                case "sqlserver": {
                    datasource.setType(Datasource.Type.Custom.name());
                    break;
                }
                case "polardb": {
                    datasource.setType(Datasource.Type.PolarX.name());
                    break;
                }
                case "oracle": {
                    datasource.setType(Datasource.Type.Oracle.name());
                    break;
                }
                case "mongodb": {
                    datasource.setType(Datasource.Type.Custom.name());
                    break;
                }
                case "emr": {
                    datasource.setType(Datasource.Type.Custom.name());
                    break;
                }
                case "postgresql": {
                    datasource.setType(Datasource.Type.PG.name());
                    break;
                }
                case "analyticdb_for_mysql": {
                    datasource.setType(Datasource.Type.Custom.name());
                    break;
                }
                case "hybriddb_for_postgresql": {
                    datasource.setType(Datasource.Type.Custom.name());
                    break;
                }
                case "holo": {
                    datasource.setType(Datasource.Type.Hologres.name());
                }
            }
            datasource.getCustomProperties().put("description", ds.getDescription());
            datasource.getCustomProperties().put("expireTime", this.str2LocalDateTime(ds.getGmtCreate()));
            datasource.getCustomProperties().put("content", ds.getContent());
            if (ds.getBindingCalcEngineId() != null) {
                datasource.getCustomProperties().put("BindingCalcEngineId", Long.toString(ds.getBindingCalcEngineId()));
            }
            datasources.add(datasource);
        }
    }

    public LocalDateTime str2LocalDateTime(String dateTimeStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM dd, yyyy h:mm:ss a");
        try {
            LocalDateTime dateTime = LocalDateTime.parse(dateTimeStr, formatter);
            return dateTime;
        }
        catch (DateTimeParseException e) {
            log.warn("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u65f6\u95f4\u5b57\u7b26\u4e32: " + dateTimeStr);
            return null;
        }
    }
}

