/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.transformer.dolphinscheduler;

import com.aliyun.dataworks.common.spec.SpecUtil;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.DagDataSchedule;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.DolphinSchedulerV3FlowSpecConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.model.SpecRefEntityWrapper;
import com.aliyun.dataworks.migrationx.transformer.flowspec.transformer.AbstractTransformer;
import com.aliyun.dataworks.migrationx.transformer.flowspec.transformer.dolphinscheduler.DolphinSchedulerV3FlowSpecTransformerConfig;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.aliyun.migrationx.common.utils.JsonFileUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerV3FlowSpecTransformer
extends AbstractTransformer {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerV3FlowSpecTransformer.class);
    protected final List<DagDataSchedule> dagDataScheduleList;
    protected final List<Specification<DataWorksWorkflowSpec>> specificationList;
    protected DolphinSchedulerV3ConverterContext context;

    public DolphinSchedulerV3FlowSpecTransformer(String configPath, String sourcePath, String targetPath) {
        this.configPath = configPath;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
        this.dagDataScheduleList = new ArrayList<DagDataSchedule>();
        this.specificationList = new ArrayList<Specification<DataWorksWorkflowSpec>>();
    }

    @Override
    public void transform() {
        this.read();
        this.doTransform();
        this.write();
    }

    private void read() {
        try {
            JsonNode jsonNode;
            this.context = this.parseContext();
            JsonParser jsonParser = JsonFileUtils.buildJsonParser((InputStream)Files.newInputStream(Paths.get(this.sourcePath, new String[0]), new OpenOption[0]));
            while ((jsonNode = JSONUtils.readObjFromParser((JsonParser)jsonParser)) != null) {
                this.dagDataScheduleList.add((DagDataSchedule)JSONUtils.parseObject((JsonNode)jsonNode, DagDataSchedule.class));
            }
        }
        catch (IOException e) {
            log.error("read config or source file error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void doTransform() {
        ListUtils.emptyIfNull(this.context.getDependSpecification()).stream().map(Specification::getSpec).filter(Objects::nonNull).map(DataWorksWorkflowSpec::getWorkflows).filter(Objects::nonNull).flatMap(Collection::stream).filter(workflow -> StringUtils.isNotBlank((CharSequence)workflow.getId())).forEach(workflow -> this.context.getSpecRefEntityMap().put(workflow.getId(), new SpecRefEntityWrapper().setSpecRefEntity((SpecRefEntity)workflow)));
        this.specificationList.addAll(ListUtils.emptyIfNull(this.dagDataScheduleList).stream().map(dagDataSchedule -> new DolphinSchedulerV3FlowSpecConverter((DagDataSchedule)dagDataSchedule, this.context).convert()).flatMap(Collection::stream).peek(specification -> log.info("specification: {}", specification)).collect(Collectors.toList()));
    }

    private void write() {
        File targetFile = new File(this.targetPath);
        if (targetFile.exists() && !targetFile.delete()) {
            log.error("target file exists and can not be deleted, file: {}", (Object)targetFile);
            throw new BizException(ErrorCode.NO_PERMISSION, new Object[]{"delete file " + targetFile});
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));){
            writer.write("[");
            for (int i = 0; i < this.specificationList.size(); ++i) {
                writer.write(SpecUtil.writeToSpec(this.specificationList.get(i)));
                if (i == this.specificationList.size() - 1) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        catch (IOException e) {
            log.error("write to target file error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private DolphinSchedulerV3ConverterContext parseContext() {
        try {
            String content = FileUtils.readFileToString((File)new File(this.configPath), (Charset)StandardCharsets.UTF_8);
            DolphinSchedulerV3FlowSpecTransformerConfig config = (DolphinSchedulerV3FlowSpecTransformerConfig)JSONUtils.parseObject((String)content, DolphinSchedulerV3FlowSpecTransformerConfig.class);
            return Optional.ofNullable(config).map(DolphinSchedulerV3FlowSpecTransformerConfig::getContext).orElseThrow(() -> new BizException(ErrorCode.PARSE_CONFIG_FILE_FAILED, new Object[]{config}));
        }
        catch (IOException e) {
            log.error("read config file error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

