/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.subprocess;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoin;
import com.aliyun.dataworks.common.spec.domain.ref.SpecArtifact;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.subprocess.SubProcessParameters;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.migrationx.common.utils.BeanUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseSubProcessParameterConverter
extends AbstractParameterConverter<SubProcessParameters> {
    private final Map<String, String> convertIdMap = new HashMap<String, String>();

    protected BaseSubProcessParameterConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(spec, specWorkflow, taskDefinition, context);
    }

    protected SpecWorkflow copyWorkflow(SpecWorkflow specWorkflow) {
        SpecWorkflow copyWorkflow = (SpecWorkflow)BeanUtils.deepCopy((Object)specWorkflow, SpecWorkflow.class);
        copyWorkflow.setId(this.generateUuid(this.taskDefinition.getCode(), (SpecRefEntity)copyWorkflow));
        this.convertIdMap.put(specWorkflow.getId(), copyWorkflow.getId());
        copyWorkflow.setName(this.taskDefinition.getName());
        copyWorkflow.setDescription(this.taskDefinition.getDescription());
        copyWorkflow.setTrigger(this.getWorkflowTrigger());
        Optional.ofNullable(this.getWorkFlow()).map(SpecWorkflow::getStrategy).ifPresent(arg_0 -> ((SpecWorkflow)copyWorkflow).setStrategy(arg_0));
        String workflowPath = this.getScriptPath(this.taskDefinition.getName());
        Optional.ofNullable(copyWorkflow.getScript()).ifPresent(script -> {
            script.setPath(workflowPath);
            Optional.ofNullable(this.getWorkFlow()).map(SpecWorkflow::getScript).map(SpecScript::getRuntime).ifPresent(arg_0 -> ((SpecScript)script).setRuntime(arg_0));
        });
        SpecNodeOutput defaultOutput = this.getDefaultOutput(copyWorkflow, false);
        Optional.ofNullable(defaultOutput).ifPresent(output -> {
            output.setId(this.generateUuid());
            output.setData(this.convertId(output.getData()));
        });
        ListUtils.emptyIfNull((List)copyWorkflow.getInnerNodes()).forEach(node -> {
            String preId = node.getId();
            node.setId(this.generateUuid((SpecRefEntity)node));
            this.convertIdMap.put(preId, node.getId());
            ListUtils.emptyIfNull((List)node.getOutputs()).stream().filter(output -> output instanceof SpecArtifact).map(output -> (SpecArtifact)output).forEach(output -> {
                if (StringUtils.isNotBlank((CharSequence)output.getId())) {
                    String newUuid = this.generateUuid();
                    this.convertIdMap.put(output.getId(), newUuid);
                    output.setId(newUuid);
                }
            });
            Optional.ofNullable(node.getScript()).map(SpecScript::getParameters).orElse(Collections.emptyList()).forEach(v -> {
                if (StringUtils.isNotBlank((CharSequence)v.getId())) {
                    String newUuid = this.generateUuid();
                    this.convertIdMap.put(v.getId(), newUuid);
                    v.setId(newUuid);
                }
            });
            node.setTrigger(copyWorkflow.getTrigger());
            String copyNodePath = FilenameUtils.concat((String)workflowPath, (String)node.getName());
            Optional.ofNullable(node.getScript()).ifPresent(script -> script.setPath(copyNodePath));
        });
        ListUtils.emptyIfNull((List)copyWorkflow.getInnerNodes()).forEach(this::resetNode);
        ListUtils.emptyIfNull((List)copyWorkflow.getInnerDependencies()).forEach(specFlowDepend -> {
            Optional.of(specFlowDepend).map(SpecFlowDepend::getNodeId).ifPresent(this::resetNode);
            ListUtils.emptyIfNull((List)specFlowDepend.getDepends()).forEach(dep -> {
                Optional.ofNullable(dep.getNodeId()).ifPresent(this::resetNode);
                Optional.ofNullable(dep.getOutput()).ifPresent(this::resetOutput);
            });
        });
        return copyWorkflow;
    }

    private void resetNode(SpecNode node) {
        if (node == null) {
            return;
        }
        node.setId(this.convertId(node.getId()));
        Optional.ofNullable(node.getScript()).map(SpecScript::getParameters).orElse(Collections.emptyList()).forEach(v -> {
            if (StringUtils.isNotBlank((CharSequence)v.getId())) {
                v.setId(this.convertId(v.getId()));
            }
        });
        ListUtils.emptyIfNull((List)node.getInputs()).forEach(this::resetInput);
        ListUtils.emptyIfNull((List)node.getOutputs()).forEach(this::resetOutput);
        if (node.getJoin() != null) {
            this.resetJoin(node.getJoin());
            ControllerJoinCode code = this.buildControllerJoinCode(node);
            Optional.ofNullable(node.getScript()).ifPresent(script -> script.setContent(code.getContent()));
        }
    }

    private void resetJoin(SpecJoin join) {
        if (join == null) {
            return;
        }
        ListUtils.emptyIfNull((List)join.getBranches()).forEach(branch -> {
            this.resetNode(branch.getNodeId());
            this.resetOutput((Output)branch.getOutput());
        });
    }

    private void resetOutput(Output output) {
        if (output instanceof SpecArtifact) {
            ((SpecArtifact)output).setId(this.convertId(((SpecArtifact)output).getId()));
            if (output instanceof SpecNodeOutput) {
                ((SpecNodeOutput)output).setData(this.convertId(((SpecNodeOutput)output).getData()));
            }
        }
    }

    private void resetInput(Input input) {
        if (input instanceof SpecArtifact) {
            ((SpecArtifact)input).setId(this.convertId(((SpecArtifact)input).getId()));
            if (input instanceof SpecNodeOutput) {
                ((SpecNodeOutput)input).setData(this.convertId(((SpecNodeOutput)input).getData()));
            }
        }
    }

    private String convertId(String id) {
        return Optional.ofNullable(this.convertIdMap).map(map -> (String)map.get(id)).orElse(id);
    }
}

