/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.logic.dependent;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerJoinCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecEntityType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoin;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoinBranch;
import com.aliyun.dataworks.common.spec.domain.noref.SpecLogic;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DependentRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.DependentItem;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.DependentTaskModel;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.task.Dependence;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.task.dependent.DependentParameters;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.model.SpecRefEntityWrapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;

public class DependentParameterConverter
extends AbstractParameterConverter<DependentParameters> {
    private static final SpecScriptRuntime RUNTIME = new SpecScriptRuntime();

    public DependentParameterConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, TaskDefinition taskDefinition, DolphinSchedulerV3ConverterContext context) {
        super(spec, specWorkflow, taskDefinition, context);
    }

    @Override
    protected void convertParameter(SpecNode finalJoinNode) {
        Dependence.DependentFailurePolicyEnum dependentFailurePolicyEnum = Optional.ofNullable((DependentParameters)this.parameter).map(DependentParameters::getDependence).map(Dependence::getFailurePolicy).orElse(null);
        if (Dependence.DependentFailurePolicyEnum.DEPENDENT_FAILURE_WAITING.equals((Object)dependentFailurePolicyEnum)) {
            Integer rerunInterval = finalJoinNode.getRerunInterval();
            if (rerunInterval == null || rerunInterval <= 0) {
                finalJoinNode.setRerunInterval(Integer.valueOf((int)Duration.ofMinutes(1L).toMillis()));
            }
            finalJoinNode.setRerunTimes(Integer.valueOf((int)((long)((DependentParameters)this.parameter).getDependence().getFailureWaitingTime().intValue() / Duration.ofMillis(finalJoinNode.getRerunInterval().intValue()).toMinutes())));
            this.resetNodeStrategy(finalJoinNode);
        }
        if (BooleanUtils.isTrue((Boolean)this.context.getJudgeConditionOnce())) {
            finalJoinNode.setRerunTimes(Integer.valueOf(0));
            finalJoinNode.setRerunInterval(Integer.valueOf(0));
            this.resetNodeStrategy(finalJoinNode);
        }
        SpecScript script = new SpecScript();
        script.setId(this.generateUuid());
        script.setRuntime(RUNTIME);
        script.setPath(this.getScriptPath(finalJoinNode));
        finalJoinNode.setScript(script);
        Map<String, SpecWorkflow> workflowIdMap = this.buildWorkFlowIdMap();
        Optional.ofNullable((DependentParameters)this.parameter).map(DependentParameters::getDependence).ifPresent(dependence -> {
            ArrayList<SpecNode> nodeList = new ArrayList<SpecNode>();
            for (int i = 0; i < ListUtils.emptyIfNull((List)dependence.getDependTaskList()).size(); ++i) {
                SpecNode specNode;
                DependentTaskModel dependentTaskModel = (DependentTaskModel)dependence.getDependTaskList().get(i);
                List<SpecNode> subNodeList = ListUtils.emptyIfNull((List)dependentTaskModel.getDependItemList()).stream().map(this::findSubNode).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                List<SpecNodeOutput> subNodeOutputList = ListUtils.emptyIfNull((List)dependentTaskModel.getDependItemList()).stream().map(dependItem -> this.findSubNodeOutput(workflowIdMap, (DependentItem)dependItem)).flatMap(Collection::stream).collect(Collectors.toList());
                SpecJoin specJoin = this.newSpecJoin(subNodeList, subNodeOutputList, dependentTaskModel.getRelation());
                SpecNode specNode2 = specNode = dependence.getDependTaskList().size() <= 1 ? finalJoinNode : this.copyJoinNode(finalJoinNode, specJoin, "_join_" + i);
                if (specNode.getJoin() == null) {
                    specNode.setJoin(specJoin);
                    Optional.ofNullable(specNode.getScript()).ifPresent(s -> s.setContent(this.buildControllerJoinCode(specNode).getContent()));
                }
                this.addRelation(specNode, subNodeList, subNodeOutputList);
                nodeList.add(specNode);
            }
            if (CollectionUtils.size(nodeList) > 1) {
                SpecJoin specJoin = this.newSpecJoin(nodeList, null, dependence.getRelation());
                finalJoinNode.setJoin(specJoin);
                Optional.ofNullable(this.buildControllerJoinCode(finalJoinNode)).map(AbstractBaseCode::getContent).ifPresent(arg_0 -> ((SpecScript)script).setContent(arg_0));
                this.addRelation(finalJoinNode, nodeList);
            }
        });
    }

    private List<SpecNode> findSubNode(DependentItem dependentItem) {
        if (dependentItem.getDepTaskCode() == 0L) {
            return Collections.emptyList();
        }
        List<SpecRefEntityWrapper> specRefEntityWrappers = this.context.getEntityTailMap().get(dependentItem.getDepTaskCode());
        return ListUtils.emptyIfNull(specRefEntityWrappers).stream().map(SpecRefEntityWrapper::getNode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<SpecNodeOutput> findSubNodeOutput(Map<String, SpecWorkflow> workflowIdMap, DependentItem dependentItem) {
        ArrayList<SpecNodeOutput> res = new ArrayList<SpecNodeOutput>();
        if (dependentItem.getDepTaskCode() == 0L) {
            String id = this.context.getUuidFromCode(dependentItem.getDefinitionCode());
            SpecWorkflow specWorkflow = workflowIdMap.get(id);
            Optional.ofNullable(specWorkflow).map(flow -> this.getDefaultOutput(specWorkflow, false)).ifPresent(res::add);
        } else {
            String id = this.context.getUuidFromCode(dependentItem.getDepTaskCode());
            SpecRefEntityWrapper specRefEntityWrapper = this.context.getSpecRefEntityMap().get(id);
            if (SpecEntityType.WORKFLOW.equals((Object)specRefEntityWrapper.getType())) {
                SpecWorkflow specWorkflow = specRefEntityWrapper.getWorkflow();
                Optional.ofNullable(specWorkflow).map(flow -> this.getDefaultOutput(specWorkflow, false)).ifPresent(res::add);
            }
        }
        return res;
    }

    private SpecJoin newSpecJoin(List<SpecNode> specNodeList, List<SpecNodeOutput> specNodeOutputList, DependentRelation relation) {
        SpecJoin specJoin = new SpecJoin();
        specJoin.setBranches(new ArrayList());
        ArrayList branchNameList = new ArrayList();
        ListUtils.emptyIfNull(specNodeList).forEach(specNode -> {
            SpecJoinBranch specJoinBranch = this.buildSpecJoinBranch((SpecNode)specNode, ControllerJoinCode.Status.SUCCESS);
            specJoin.getBranches().add(specJoinBranch);
            branchNameList.add(specJoinBranch.getName());
        });
        ListUtils.emptyIfNull(specNodeOutputList).forEach(specNodeOutput -> {
            SpecJoinBranch specJoinBranch = this.buildSpecJoinBranch((SpecNodeOutput)specNodeOutput, ControllerJoinCode.Status.SUCCESS);
            specJoin.getBranches().add(specJoinBranch);
            branchNameList.add(specJoinBranch.getName());
        });
        SpecLogic specLogic = new SpecLogic();
        specLogic.setExpression(String.join((CharSequence)(" " + relation.name() + " "), branchNameList));
        specJoin.setLogic(specLogic);
        specJoin.setResultStatus(ControllerJoinCode.Status.SUCCESS.getCode());
        return specJoin;
    }

    private Map<String, SpecWorkflow> buildWorkFlowIdMap() {
        ArrayList<SpecWorkflow> workflows = new ArrayList<SpecWorkflow>(Collections.singleton(this.getWorkFlow()));
        ListUtils.emptyIfNull(this.context.getDependSpecification()).stream().map(Specification::getSpec).filter(Objects::nonNull).map(DataWorksWorkflowSpec::getWorkflows).filter(Objects::nonNull).flatMap(Collection::stream).forEach(workflows::add);
        this.context.getSpecRefEntityMap().values().stream().filter(specRefEntityWrapper -> SpecEntityType.WORKFLOW.equals((Object)specRefEntityWrapper.getType())).map(SpecRefEntityWrapper::getWorkflow).forEach(workflows::add);
        return workflows.stream().filter(Objects::nonNull).collect(Collectors.toMap(SpecRefEntity::getId, Function.identity(), (v1, v2) -> v1));
    }

    static {
        RUNTIME.setEngine(CodeProgramType.CONTROLLER_JOIN.getCalcEngineType().getLabel());
        RUNTIME.setCommand(CodeProgramType.CONTROLLER_JOIN.getName());
    }
}

