/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.FailureStrategy;
import com.aliyun.dataworks.common.spec.domain.enums.NodeInstanceModeType;
import com.aliyun.dataworks.common.spec.domain.enums.NodeRerunModeType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScheduleStrategy;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.DagDataSchedule;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.ParamListConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.SpecFlowDependConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.SpecNodeListConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.TriggerConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowConverter
extends AbstractCommonConverter<SpecWorkflow> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowConverter.class);
    private final SpecWorkflow workflow;
    private final DagDataSchedule dagDataSchedule;
    private static final SpecScriptRuntime WORKFLOW_RUNTIME = new SpecScriptRuntime();
    private static final SpecScriptRuntime MANUAL_WORKFLOW_RUNTIME = new SpecScriptRuntime();

    public WorkflowConverter(SpecWorkflow workflow, DagDataSchedule dagDataSchedule, DolphinSchedulerV3ConverterContext context) {
        super(context);
        this.workflow = Optional.ofNullable(workflow).orElseGet(this::initWorkflow);
        this.dagDataSchedule = dagDataSchedule;
    }

    public WorkflowConverter(DagDataSchedule dagDataSchedule, DolphinSchedulerV3ConverterContext context) {
        this(null, dagDataSchedule, context);
    }

    private SpecWorkflow initWorkflow() {
        SpecWorkflow specWorkflow = new SpecWorkflow();
        specWorkflow.setDependencies(new ArrayList());
        specWorkflow.setNodes(new ArrayList());
        specWorkflow.setInputs(new ArrayList());
        specWorkflow.setOutputs(new ArrayList());
        return specWorkflow;
    }

    @Override
    public SpecWorkflow convert() {
        if (Objects.isNull(this.dagDataSchedule) || Objects.isNull(this.dagDataSchedule.getProcessDefinition())) {
            return this.workflow;
        }
        ProcessDefinition processDefinition = this.dagDataSchedule.getProcessDefinition();
        this.convertProcess(processDefinition, this.workflow, this.context);
        this.convertTrigger(this.dagDataSchedule.getSchedule(), this.workflow, processDefinition, this.workflow.getScript(), this.context);
        this.convertTaskDefinitions(this.dagDataSchedule.getTaskDefinitionList(), this.workflow, this.context);
        this.convertTaskRelations(this.dagDataSchedule.getProcessTaskRelationList(), this.workflow, this.context);
        return this.workflow;
    }

    protected void convertProcess(ProcessDefinition processDefinition, SpecWorkflow specWorkflow, DolphinSchedulerV3ConverterContext context) {
        log.info("convert workflow,processDefinition: {}", (Object)this.dagDataSchedule.getProcessDefinition());
        specWorkflow.setId(this.generateUuid(processDefinition.getCode(), (SpecRefEntity)specWorkflow));
        specWorkflow.setName(processDefinition.getName());
        specWorkflow.setDescription(processDefinition.getDescription());
        Object specVariableList = new ParamListConverter(processDefinition.getGlobalParamList(), context).convert();
        log.info("convert workflow,global params: {}", specVariableList);
        SpecScript script = new SpecScript();
        script.setParameters((List)specVariableList);
        script.setRuntime(MANUAL_WORKFLOW_RUNTIME);
        script.setPath(FilenameUtils.concat((String)StringUtils.defaultString((String)context.getDefaultScriptPath()), (String)specWorkflow.getName()));
        specWorkflow.setScript(script);
        specWorkflow.getOutputs().add(this.buildDefaultOutput(specWorkflow));
    }

    protected void convertTrigger(Schedule schedule, SpecWorkflow specWorkflow, ProcessDefinition processDefinition, SpecScript script, DolphinSchedulerV3ConverterContext context) {
        if (Objects.nonNull(this.dagDataSchedule.getSchedule())) {
            SpecTrigger trigger = new TriggerConverter(schedule, context).convert();
            specWorkflow.setTrigger(trigger);
            specWorkflow.setStrategy(this.buildSpecScheduleStrategy(processDefinition, schedule));
            script.setRuntime(WORKFLOW_RUNTIME);
            log.info("convert workflow,schedule: {}", (Object)schedule);
        }
    }

    protected void convertTaskDefinitions(List<TaskDefinition> taskDefinitions, SpecWorkflow specWorkflow, DolphinSchedulerV3ConverterContext context) {
        log.info("convert workflow,taskDefinitionList: {}", taskDefinitions);
        new SpecNodeListConverter(null, specWorkflow, taskDefinitions, context).convert();
    }

    protected void convertTaskRelations(List<ProcessTaskRelation> processTaskRelationList, SpecWorkflow specWorkflow, DolphinSchedulerV3ConverterContext context) {
        log.info("convert workflow,processTaskRelationList: {}", processTaskRelationList);
        new SpecFlowDependConverter(null, specWorkflow, processTaskRelationList, context).convert();
    }

    private SpecNodeOutput buildDefaultOutput(SpecWorkflow specWorkflow) {
        SpecNodeOutput specNodeOutput = new SpecNodeOutput();
        specNodeOutput.setIsDefault(Boolean.valueOf(true));
        specNodeOutput.setId(this.generateUuid());
        specNodeOutput.setData(specWorkflow.getId());
        specNodeOutput.setRefTableName(specWorkflow.getName());
        return specNodeOutput;
    }

    private SpecScheduleStrategy buildSpecScheduleStrategy(ProcessDefinition processDefinition, Schedule schedule) {
        SpecScheduleStrategy strategy = new SpecScheduleStrategy();
        strategy.setPriority(this.convertPriority(schedule.getProcessInstancePriority()));
        strategy.setTimeout(Integer.valueOf(processDefinition.getTimeout()));
        strategy.setInstanceMode(NodeInstanceModeType.T_PLUS_1);
        strategy.setRerunMode(NodeRerunModeType.ALL_ALLOWED);
        strategy.setRerunTimes(Integer.valueOf(0));
        strategy.setRerunInterval(Integer.valueOf(0));
        strategy.setIgnoreBranchConditionSkip(Boolean.valueOf(false));
        strategy.setFailureStrategy(com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.FailureStrategy.CONTINUE.equals((Object)schedule.getFailureStrategy()) ? FailureStrategy.CONTINUE : FailureStrategy.BREAK);
        return strategy;
    }

    static {
        WORKFLOW_RUNTIME.setEngine(CodeProgramType.VIRTUAL_WORKFLOW.getCalcEngineType().getLabel());
        WORKFLOW_RUNTIME.setCommand("WORKFLOW");
        MANUAL_WORKFLOW_RUNTIME.setEngine(CodeProgramType.VIRTUAL_WORKFLOW.getCalcEngineType().getLabel());
        MANUAL_WORKFLOW_RUNTIME.setCommand("MANUAL_WORKFLOW");
    }
}

