/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.InputOutputWired;
import com.aliyun.dataworks.common.spec.domain.ref.SpecArtifact;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessTaskRelation;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import com.aliyun.dataworks.migrationx.transformer.flowspec.model.SpecRefEntityWrapper;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.BeanUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecFlowDependConverter
extends AbstractCommonConverter<List<SpecFlowDepend>> {
    private static final Logger log = LoggerFactory.getLogger(SpecFlowDependConverter.class);
    private static final Map<ArtifactType, Class<? extends SpecArtifact>> ARTIFACT_TYPE_CLASS_MAP = new EnumMap<ArtifactType, Class<? extends SpecArtifact>>(ArtifactType.class);
    private final DataWorksWorkflowSpec spec;
    private final SpecWorkflow specWorkflow;
    private final List<ProcessTaskRelation> processTaskRelationList;

    public SpecFlowDependConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, List<ProcessTaskRelation> processTaskRelationList, DolphinSchedulerV3ConverterContext context) {
        super(context);
        this.spec = spec;
        this.specWorkflow = specWorkflow;
        this.processTaskRelationList = processTaskRelationList;
    }

    @Override
    public List<SpecFlowDepend> convert() {
        if (Objects.nonNull(this.specWorkflow)) {
            this.specWorkflow.setDependencies(this.convertTaskRelationList(this.processTaskRelationList));
            return this.specWorkflow.getDependencies();
        }
        this.spec.setFlow(this.convertTaskRelationList(this.processTaskRelationList));
        return this.spec.getFlow();
    }

    private List<SpecFlowDepend> convertTaskRelationList(List<ProcessTaskRelation> taskRelationList) {
        List flow = Optional.ofNullable(this.specWorkflow).map(SpecWorkflow::getDependencies).orElse(Optional.ofNullable(this.spec).map(DataWorksWorkflowSpec::getFlow).orElse(new ArrayList()));
        Map<String, List> nodeIdDependMap = flow.stream().collect(Collectors.toMap(o -> o.getNodeId().getId(), SpecFlowDepend::getDepends));
        for (ProcessTaskRelation processTaskRelation : ListUtils.emptyIfNull(taskRelationList)) {
            long preTaskCode = processTaskRelation.getPreTaskCode();
            long postTaskCode = processTaskRelation.getPostTaskCode();
            if (preTaskCode == 0L) continue;
            List preEntityList = this.context.getEntityTailMap().getOrDefault(preTaskCode, Collections.emptyList());
            List<SpecRefEntityWrapper> postEntityList = this.context.getEntityHeadMap().getOrDefault(postTaskCode, Collections.emptyList());
            postEntityList.forEach(postNode -> this.dealSingleNodeDependency((SpecRefEntityWrapper)((Object)postNode), (Map<String, List<SpecDepend>>)nodeIdDependMap, flow, preEntityList));
        }
        return flow;
    }

    private void dealSingleNodeDependency(SpecRefEntityWrapper postNode, Map<String, List<SpecDepend>> nodeIdDependMap, List<SpecFlowDepend> flow, List<SpecRefEntityWrapper> preEntityList) {
        if (Optional.ofNullable(postNode.getNode()).map(SpecNode::getJoin).isPresent()) {
            return;
        }
        List specDependList = ListUtils.defaultIfNull(nodeIdDependMap.get(postNode.getId()), new ArrayList());
        assert (specDependList != null);
        if (CollectionUtils.isEmpty((Collection)specDependList)) {
            SpecFlowDepend specFlowDepend = this.newSpecFlowDepend();
            specFlowDepend.setNodeId(postNode.getNode());
            specFlowDepend.setDepends(specDependList);
            if (specFlowDepend.getNodeId() != null) {
                flow.add(specFlowDepend);
                nodeIdDependMap.put(postNode.getId(), specDependList);
            }
        }
        this.setPostNodeDependenciesAndInput(postNode, preEntityList, specDependList);
        this.transformVariableInput2ScriptVariable(postNode);
    }

    private void setPostNodeDependenciesAndInput(SpecRefEntityWrapper postNode, List<SpecRefEntityWrapper> preEntityList, List<SpecDepend> specDependList) {
        Set<String> preEntityIdSet = specDependList.stream().map(SpecDepend::getNodeId).filter(Objects::nonNull).map(SpecRefEntity::getId).collect(Collectors.toSet());
        Set preEntityOutputDataSet = specDependList.stream().map(SpecDepend::getOutput).filter(Objects::nonNull).map(SpecNodeOutput::getData).collect(Collectors.toSet());
        if (this.isConditionNode(preEntityIdSet, preEntityList)) {
            log.info("dependencies is dealt in previous step, post node: {}, pre nodes: {}", (Object)postNode, preEntityList);
            return;
        }
        for (SpecRefEntityWrapper preEntity : preEntityList) {
            SpecNodeOutput defaultOutput = this.getDefaultNodeOutput(preEntity);
            if (preEntityIdSet.contains(preEntity.getId()) || preEntityOutputDataSet.contains(Optional.ofNullable(defaultOutput).map(SpecNodeOutput::getData).orElse(null))) continue;
            preEntityIdSet.add(postNode.getId());
            Optional.ofNullable(defaultOutput).map(SpecNodeOutput::getData).ifPresent(preEntityOutputDataSet::add);
            SpecDepend specDepend = new SpecDepend(preEntity.getNode(), DependencyType.NORMAL, defaultOutput);
            specDependList.add(specDepend);
            postNode.getInputs().addAll(this.transformOutput2Input(preEntity));
        }
    }

    private boolean isConditionNode(Set<String> preEntityIdSet, List<SpecRefEntityWrapper> preEntityList) {
        if (CollectionUtils.size(preEntityList) != 2) {
            return false;
        }
        return ListUtils.emptyIfNull(preEntityList).stream().map(SpecRefEntityWrapper::getId).filter(preEntityIdSet::contains).count() == 1L;
    }

    private void transformVariableInput2ScriptVariable(SpecRefEntityWrapper postNode) {
        List scriptParam = Optional.ofNullable(postNode.getScript()).map(SpecScript::getParameters).orElseGet(() -> {
            SpecScript script = postNode.getScript();
            if (script == null) {
                log.error("node.script not set, node id: {}", (Object)postNode.getId());
                return new ArrayList();
            }
            script.setParameters(new ArrayList());
            return script.getParameters();
        });
        ListUtils.emptyIfNull(postNode.getInputs()).stream().filter(input -> input instanceof SpecVariable).map(input -> (SpecVariable)input).filter(specVariable -> VariableScopeType.NODE_CONTEXT.equals((Object)specVariable.getScope())).forEach(specVariable -> {
            SpecVariable param = (SpecVariable)BeanUtils.deepCopy((Object)specVariable, SpecVariable.class);
            param.setId(this.generateUuid());
            param.setNode(null);
            param.setScope(VariableScopeType.NODE_PARAMETER);
            param.setReferenceVariable(specVariable);
            scriptParam.add(param);
        });
    }

    private List<? extends Input> transformOutput2Input(SpecRefEntityWrapper entity) {
        ArrayList res = new ArrayList();
        ListUtils.emptyIfNull(Optional.ofNullable(entity).orElseThrow(() -> new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"spec node"})).getOutputs()).forEach(output -> {
            if (output instanceof SpecArtifact) {
                SpecArtifact specArtifactOutput = (SpecArtifact)output;
                Class<? extends SpecArtifact> clazz = ARTIFACT_TYPE_CLASS_MAP.get(specArtifactOutput.getArtifactType());
                SpecArtifact specArtifactInput = (SpecArtifact)BeanUtils.deepCopy((Object)specArtifactOutput, clazz);
                res.add(specArtifactInput);
            }
        });
        return res;
    }

    private SpecNodeOutput getDefaultNodeOutput(InputOutputWired inputOutputWired) {
        return ListUtils.emptyIfNull((List)inputOutputWired.getOutputs()).stream().filter(o -> o instanceof SpecNodeOutput && ((SpecNodeOutput)o).getIsDefault() != false).map(o -> (SpecNodeOutput)o).findFirst().orElse(null);
    }

    static {
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.TABLE, SpecTable.class);
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.VARIABLE, SpecVariable.class);
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.NODE_OUTPUT, SpecNodeOutput.class);
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.FILE, SpecArtifact.class);
    }
}

