/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.DagDataSchedule;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.FlowSpecConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.WorkflowConverter;
import com.aliyun.dataworks.migrationx.transformer.flowspec.converter.dolphinscheduler.common.context.DolphinSchedulerV3ConverterContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinSchedulerV3FlowSpecConverter
implements FlowSpecConverter<DagDataSchedule> {
    private static final Logger log = LoggerFactory.getLogger(DolphinSchedulerV3FlowSpecConverter.class);
    private static final SpecVersion SPEC_VERSION = SpecVersion.V_1_2_0;
    private final DagDataSchedule dagDataSchedule;
    private final Specification<DataWorksWorkflowSpec> specification;
    private final DolphinSchedulerV3ConverterContext context;

    public DolphinSchedulerV3FlowSpecConverter(DagDataSchedule dagDataSchedule, DolphinSchedulerV3ConverterContext context) {
        this.dagDataSchedule = (DagDataSchedule)ObjectUtils.defaultIfNull((Object)dagDataSchedule, (Object)new DagDataSchedule());
        this.context = (DolphinSchedulerV3ConverterContext)ObjectUtils.defaultIfNull((Object)context, (Object)new DolphinSchedulerV3ConverterContext());
        this.specification = new Specification();
        this.specification.setMetadata(new HashMap());
        this.specification.setSpec((Spec)this.initSpec());
        this.checkContext();
    }

    private void checkContext() {
        MapUtils.emptyIfNull(this.context.getDataSourceMap()).values().forEach(datasource -> datasource.setIsRef(Boolean.valueOf(false)));
        if (Objects.isNull(this.context.getSpecVersion())) {
            this.context.setSpecVersion(SPEC_VERSION.getLabel());
        }
    }

    private DataWorksWorkflowSpec initSpec() {
        DataWorksWorkflowSpec spec = new DataWorksWorkflowSpec();
        spec.setVariables(new ArrayList());
        spec.setTriggers(new ArrayList());
        spec.setScripts(new ArrayList());
        spec.setFiles(new ArrayList());
        spec.setArtifacts(new ArrayList());
        spec.setDatasources(new ArrayList());
        spec.setDqcRules(new ArrayList());
        spec.setRuntimeResources(new ArrayList());
        spec.setFileResources(new ArrayList());
        spec.setFunctions(new ArrayList());
        spec.setNodes(new ArrayList());
        spec.setWorkflows(new ArrayList());
        spec.setComponents(new ArrayList());
        spec.setFlow(new ArrayList());
        return spec;
    }

    @Override
    public List<Specification<DataWorksWorkflowSpec>> convert(DagDataSchedule from) {
        this.specification.setKind((Objects.isNull(from.getSchedule()) ? SpecKind.MANUAL_WORKFLOW : SpecKind.CYCLE_WORKFLOW).getLabel());
        this.specification.setVersion(this.context.getSpecVersion());
        log.info("====== start convert ======,version:{}", (Object)this.specification.getVersion());
        this.doConvert(from);
        log.info("====== finish convert ======");
        return this.flattenFlowSpec(this.specification);
    }

    public List<Specification<DataWorksWorkflowSpec>> convert() {
        return this.convert(this.dagDataSchedule);
    }

    private void doConvert(DagDataSchedule from) {
        DataWorksWorkflowSpec spec = (DataWorksWorkflowSpec)this.specification.getSpec();
        SpecWorkflow workflow = new WorkflowConverter(from, this.context).convert();
        if (CollectionUtils.isEmpty(this.context.getSubWorkflows())) {
            spec.getWorkflows().add(workflow);
            this.specification.getMetadata().put("uuid", workflow.getId());
        } else {
            spec.getWorkflows().addAll(this.context.getSubWorkflows());
            spec.getNodes().addAll(workflow.getNodes());
            spec.getFlow().addAll(workflow.getDependencies());
            this.context.getSubWorkflows().clear();
        }
    }

    private List<Specification<DataWorksWorkflowSpec>> flattenFlowSpec(Specification<DataWorksWorkflowSpec> specification) {
        if (specification == null) {
            return null;
        }
        List specWorkflows = Optional.ofNullable((DataWorksWorkflowSpec)specification.getSpec()).map(DataWorksWorkflowSpec::getWorkflows).orElse(Collections.emptyList());
        List specNodes = Optional.ofNullable((DataWorksWorkflowSpec)specification.getSpec()).map(DataWorksWorkflowSpec::getNodes).orElse(Collections.emptyList());
        if (CollectionUtils.size(specWorkflows) <= 1 && CollectionUtils.isEmpty(specNodes)) {
            return Collections.singletonList(specification);
        }
        List flowSpecList = ListUtils.emptyIfNull(specWorkflows).stream().map(specWorkflow -> {
            Specification template = new Specification();
            template.setContext(specification.getContext());
            template.setMetadata(new HashMap());
            template.setVersion(specification.getVersion());
            template.setKind(specification.getKind());
            template.getMetadata().put("uuid", specWorkflow.getId());
            DataWorksWorkflowSpec spec = new DataWorksWorkflowSpec();
            template.setSpec((Spec)spec);
            spec.setWorkflows(Collections.singletonList(specWorkflow));
            return template;
        }).collect(Collectors.toList());
        List specFlowDepends = Optional.ofNullable((DataWorksWorkflowSpec)specification.getSpec()).map(DataWorksWorkflowSpec::getFlow).orElse(Collections.emptyList());
        List nodeSpecList = ListUtils.emptyIfNull(specNodes).stream().map(specNode -> {
            Specification template = new Specification();
            template.setContext(specification.getContext());
            template.setMetadata(new HashMap());
            template.setVersion(specification.getVersion());
            template.setKind(SpecKind.NODE.getLabel());
            template.getMetadata().put("uuid", specNode.getId());
            DataWorksWorkflowSpec spec = new DataWorksWorkflowSpec();
            template.setSpec((Spec)spec);
            spec.setNodes(Collections.singletonList(specNode));
            List specFlowDependsForNode = specFlowDepends.stream().filter(specFlowDepend -> Optional.ofNullable(specFlowDepend.getNodeId()).map(SpecRefEntity::getId).filter(id -> id.equals(specNode.getId())).isPresent()).collect(Collectors.toList());
            spec.setFlow(specFlowDependsForNode);
            return template;
        }).collect(Collectors.toList());
        return ListUtils.union(flowSpecList, nodeSpecList);
    }

    public Specification<DataWorksWorkflowSpec> getSpecification() {
        return this.specification;
    }
}

