/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.sql;

import com.aliyun.dataworks.common.spec.domain.ref.SpecDatasource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.SqlType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractNodeConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SqlNodeConverter
extends AbstractNodeConverter<SqlParameters> {
    public SqlNodeConverter(SpecNode specNode, FlowSpecConverterContext context) {
        super(specNode, context);
    }

    @Override
    protected SqlParameters convertParameter() {
        SqlParameters sqlParameters = new SqlParameters();
        SpecDatasource datasource = this.specNode.getDatasource();
        if (this.checkDatasource(datasource)) {
            sqlParameters.setType(datasource.getType());
            sqlParameters.setDatasource(Integer.parseInt(StringUtils.defaultString((String)datasource.getId(), (String)"1")));
        } else {
            this.setDefaultDataSource(sqlParameters);
        }
        String content = Optional.ofNullable(this.specNode.getScript()).map(SpecScript::getContent).orElse("");
        sqlParameters.setSql(content);
        sqlParameters.setSqlType(SqlType.QUERY.ordinal());
        sqlParameters.setPreStatements(new ArrayList());
        sqlParameters.setPostStatements(new ArrayList());
        sqlParameters.setDisplayRows(10);
        return sqlParameters;
    }

    private void setDefaultDataSource(SqlParameters sqlParameters) {
        sqlParameters.setType(this.context.getDefaultDatasourceType());
        sqlParameters.setDatasource(((Integer)ObjectUtils.defaultIfNull((Object)this.context.getDefaultDatasourceId(), (Object)1)).intValue());
    }

    private boolean checkDatasource(SpecDatasource datasource) {
        if (Objects.isNull(datasource)) {
            return false;
        }
        DbType[] values = DbType.values();
        return Arrays.stream(values).map(Enum::name).anyMatch(s -> s.equals(datasource.getType()));
    }

    @Override
    protected void setTaskType() {
        ((TaskDefinition)this.result).setTaskType(TaskType.SQL.name());
    }
}

