/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.spark;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.spark.SparkParameters;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class SparkSubmitConfigParser {
    private final List<String> configs;
    private final SparkParameters sparkParameters;

    public SparkSubmitConfigParser(SparkParameters sparkParameters, List<String> configs) {
        this.configs = configs;
        this.sparkParameters = sparkParameters;
    }

    private void init() {
        if (Objects.nonNull(this.sparkParameters)) {
            this.sparkParameters.setDriverCores(1);
            this.sparkParameters.setNumExecutors(2);
            this.sparkParameters.setExecutorCores(2);
            this.sparkParameters.setDriverMemory("512M");
            this.sparkParameters.setExecutorMemory("2G");
        }
    }

    public void parse() {
        this.init();
        ListUtils.emptyIfNull(this.configs).stream().filter(StringUtils::isNotBlank).forEach(config -> {
            String[] split = config.trim().split("=");
            if (split.length == 2) {
                this.handle(this.sparkParameters, split[0], split[1]);
            }
        });
    }

    private void handle(SparkParameters sparkParameters, String key, String value) {
        switch (key) {
            case "spark.driver.cores": {
                sparkParameters.setDriverCores(Integer.parseInt(value));
                break;
            }
            case "spark.executor.instances": {
                sparkParameters.setNumExecutors(Integer.parseInt(value));
                break;
            }
            case "spark.executor.cores": {
                sparkParameters.setExecutorCores(Integer.parseInt(value));
                break;
            }
            case "spark.driver.memory": {
                sparkParameters.setDriverMemory(value);
                break;
            }
            case "spark.executor.memory": {
                sparkParameters.setExecutorMemory(value);
                break;
            }
            case "spark.driver.extraJavaOptions": 
            case "spark.executor.extraJavaOptions": {
                this.appendConf(sparkParameters, key, value);
                break;
            }
        }
    }

    private void appendConf(SparkParameters sparkParameters, String key, String value) {
        String others = sparkParameters.getOthers();
        others = others + " --conf \"" + key + "=" + value + "\"";
        sparkParameters.setOthers(others);
    }
}

