/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.spark;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.TaskType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.spark.SparkParameters;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractNodeConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.spark.SparkSubmitConfigParser;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SparkNodeConverter
extends AbstractNodeConverter<SparkParameters> {
    public SparkNodeConverter(SpecNode specNode, FlowSpecConverterContext context) {
        super(specNode, context);
    }

    @Override
    protected SparkParameters convertParameter() {
        SparkParameters sparkParameters = new SparkParameters();
        sparkParameters.setResourceList(new ArrayList());
        Optional.ofNullable(this.specNode.getScript()).map(SpecScript::getContent).ifPresent(content -> {
            OdpsSparkCode sparkCode = (OdpsSparkCode)JSONObject.parseObject((String)content, OdpsSparkCode.class);
            OdpsSparkCode.CodeJson sparkJson = sparkCode.getSparkJson();
            ResourceInfo mainJar = new ResourceInfo();
            String mainResourceName = FilenameUtils.concat((String)this.context.getDefaultFileResourcePath(), (String)StringUtils.defaultString((String)sparkJson.getMainJar(), (String)sparkJson.getMainPy()));
            mainJar.setResourceName(mainResourceName);
            sparkParameters.setMainJar(mainJar);
            sparkParameters.setMainClass(sparkJson.getMainClass());
            sparkParameters.setDeployMode("local");
            sparkParameters.setMainArgs(sparkJson.getArgs());
            new SparkSubmitConfigParser(sparkParameters, sparkJson.getConfigs()).parse();
            sparkParameters.setAppName(null);
            sparkParameters.setOthers(null);
            sparkParameters.setProgramType(ProgramType.valueOf((String)StringUtils.upperCase((String)sparkJson.getLanguage())));
        });
        this.convertResourceList().forEach(sparkParameters.getResourceList()::add);
        return sparkParameters;
    }

    @Override
    protected void setTaskType() {
        ((TaskDefinition)this.result).setTaskType(TaskType.SPARK.name());
    }
}

