/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common;

import com.aliyun.dataworks.common.spec.domain.enums.TriggerType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.FailureStrategy;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.WarningType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.Priority;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v301.ReleaseState;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.AbstractCommonConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.migrationx.common.utils.DateUtils;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ScheduleConverter
extends AbstractCommonConverter<Schedule> {
    private final SpecTrigger specTrigger;
    private final ProcessDefinition processDefinition;

    public ScheduleConverter(Schedule schedule, SpecTrigger specTrigger, ProcessDefinition processDefinition, FlowSpecConverterContext context) {
        super(Objects.nonNull(schedule) ? schedule : new Schedule(), context);
        this.processDefinition = processDefinition;
        this.specTrigger = specTrigger;
    }

    public ScheduleConverter(SpecTrigger specTrigger, ProcessDefinition processDefinition, FlowSpecConverterContext context) {
        this(null, specTrigger, processDefinition, context);
    }

    @Override
    public Schedule convert() {
        if (Objects.isNull(this.specTrigger) || Objects.isNull(this.processDefinition) || !TriggerType.SCHEDULER.equals((Object)this.specTrigger.getType())) {
            return null;
        }
        ((Schedule)this.result).setId(this.generateId(this.specTrigger.getId()));
        ((Schedule)this.result).setProcessDefinitionCode(this.processDefinition.getCode());
        ((Schedule)this.result).setProcessDefinitionName(this.processDefinition.getName());
        ((Schedule)this.result).setProjectName(this.processDefinition.getProjectName());
        ((Schedule)this.result).setDefinitionDescription(this.processDefinition.getDescription());
        ((Schedule)this.result).setStartTime(DateUtils.convertStringToDate((String)this.specTrigger.getStartTime()));
        ((Schedule)this.result).setEndTime(DateUtils.convertStringToDate((String)this.specTrigger.getEndTime()));
        ((Schedule)this.result).setTimezoneId(this.specTrigger.getTimezone());
        ((Schedule)this.result).setCrontab(this.specCron2DolphinCron(this.specTrigger.getCron()));
        ((Schedule)this.result).setFailureStrategy(FailureStrategy.END);
        ((Schedule)this.result).setWarningType(WarningType.NONE);
        ((Schedule)this.result).setCreateTime(new Date());
        ((Schedule)this.result).setUpdateTime(new Date());
        ((Schedule)this.result).setUserId(((Integer)ObjectUtils.defaultIfNull((Object)this.context.getUserId(), (Object)1)).intValue());
        ((Schedule)this.result).setUserName(null);
        ((Schedule)this.result).setReleaseState(BooleanUtils.isTrue((Boolean)this.context.getOnlineSchedule()) ? ReleaseState.ONLINE : ReleaseState.OFFLINE);
        this.processDefinition.setScheduleReleaseState(((Schedule)this.result).getReleaseState());
        ((Schedule)this.result).setWarningGroupId(0);
        ((Schedule)this.result).setProcessInstancePriority(Priority.MEDIUM);
        ((Schedule)this.result).setWorkerGroup(StringUtils.defaultString((String)this.context.getWorkerGroup(), (String)"default"));
        ((Schedule)this.result).setTenantCode(StringUtils.defaultString((String)this.context.getTenantCode(), (String)"default"));
        ((Schedule)this.result).setEnvironmentCode((Long)ObjectUtils.defaultIfNull((Object)this.context.getEnvironmentCode(), (Object)-1L));
        ((Schedule)this.result).setEnvironmentName(null);
        return (Schedule)this.result;
    }

    private String specCron2DolphinCron(String specCron) {
        return specCron;
    }
}

