/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common;

import com.aliyun.dataworks.migrationx.transformer.core.utils.CodeGenerateUtils;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;

public abstract class AbstractCommonConverter<T> {
    protected T result;
    protected FlowSpecConverterContext context;

    protected AbstractCommonConverter(T result, FlowSpecConverterContext context) {
        this.result = result;
        this.context = context;
    }

    protected AbstractCommonConverter(FlowSpecConverterContext context) {
        this.context = context;
    }

    protected abstract T convert();

    protected int generateId(String id) {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return RandomUtils.nextInt((int)100000000, (int)999999999);
        }
    }

    protected long generateCode(String id) {
        if (Objects.isNull(id)) {
            throw new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"id"});
        }
        Long code = this.context.getIdCodeMap().get(id);
        if (Objects.nonNull(code)) {
            return code;
        }
        try {
            code = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            code = CodeGenerateUtils.getInstance().genCode();
        }
        this.context.getIdCodeMap().put(id, code);
        return code;
    }
}

