/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTrigger;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.LocationUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.Schedule;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.v320.DagDataSchedule;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.DolphinSchedulerConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.ProcessDefinitionConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.ProcessTaskRelationListConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.ScheduleConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.TaskDefinitionListConverter;
import com.aliyun.dataworks.migrationx.transformer.dolphinscheduler.converter.flowspec.common.context.FlowSpecConverterContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecWorkflowDolphinSchedulerV3Converter
implements DolphinSchedulerConverter<SpecWorkflow> {
    private static final Logger log = LoggerFactory.getLogger(SpecWorkflowDolphinSchedulerV3Converter.class);
    private final DataWorksWorkflowSpec spec;
    private final SpecWorkflow workflow;
    private final FlowSpecConverterContext context;
    private final DagDataSchedule dagDataSchedule;
    private static final int X_STEP = 350;
    private static final int Y_STEP = 150;

    public SpecWorkflowDolphinSchedulerV3Converter(DataWorksWorkflowSpec spec, SpecWorkflow workflow, FlowSpecConverterContext context) {
        this.spec = spec;
        this.context = context;
        this.workflow = workflow;
        this.dagDataSchedule = new DagDataSchedule();
    }

    @Override
    public DagDataSchedule convert(SpecWorkflow from) {
        if (Objects.isNull(this.spec) || Objects.isNull(from)) {
            log.error("spec or workflow is null");
            throw new BizException(ErrorCode.PARAMETER_NOT_SET, new Object[]{"spec or workflow"});
        }
        ProcessDefinition processDefinition = new ProcessDefinitionConverter(this.spec, from, this.context).convert();
        log.info("processDefinition: {}", (Object)processDefinition);
        Schedule schedule = new ScheduleConverter(this.findSpecTrigger(from), processDefinition, this.context).convert();
        log.info("schedule: {}", (Object)schedule);
        Object taskDefinitionList = new TaskDefinitionListConverter(this.spec, from, this.context).convert();
        log.info("taskDefinitionList: {}", taskDefinitionList);
        Object processTaskRelationList = new ProcessTaskRelationListConverter(this.spec, from, this.context).convert();
        log.info("processTaskRelationList: {}", processTaskRelationList);
        processDefinition.setLocations(LocationUtils.buildLocations((List)processTaskRelationList, (int)350, (int)150));
        this.dagDataSchedule.setProcessDefinition(processDefinition);
        this.dagDataSchedule.setSchedule(schedule);
        this.dagDataSchedule.setTaskDefinitionList((List)taskDefinitionList);
        this.dagDataSchedule.setProcessTaskRelationList((List)processTaskRelationList);
        return this.dagDataSchedule;
    }

    public DagDataSchedule convert() {
        return this.convert(this.workflow);
    }

    private SpecTrigger findSpecTrigger(SpecWorkflow workflow) {
        Optional<SpecTrigger> specTriggerOpt = Optional.ofNullable(workflow).map(SpecWorkflow::getTrigger);
        return specTriggerOpt.orElseGet(() -> Optional.ofNullable(workflow).map(SpecWorkflow::getNodes).orElse(Collections.emptyList()).stream().map(SpecNode::getTrigger).filter(Objects::nonNull).findFirst().orElse(null));
    }
}

