/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.transformer;

import com.aliyun.dataworks.common.spec.SpecUtil;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.ResourceComponent;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.workflow.DolphinSchedulerV1WorkflowConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.DolphinSchedulerV2WorkflowConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.DolphinSchedulerV3WorkflowConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksDolphinSchedulerTransformer;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowDolphinSchedulerTransformer
extends DataWorksDolphinSchedulerTransformer {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDolphinSchedulerTransformer.class);
    private List<Specification<DataWorksWorkflowSpec>> specifications;

    public WorkflowDolphinSchedulerTransformer(DataWorksTransformerConfig config, DolphinSchedulerPackage sourcePacakgeFile, DataWorksPackage targetPackageFile) {
        super(config, sourcePacakgeFile, targetPackageFile);
    }

    @Override
    public void transform() throws Exception {
        ((DataWorksPackage)this.targetPackage).setDwProject(this.dwProject);
        this.packageFile = ((DolphinSchedulerPackage)this.sourcePackage).getPackageFile();
        DolphinSchedulerVersion version = ((DolphinSchedulerPackage)this.sourcePackageFileService.getPackage()).getPackageInfo().getDolphinSchedulerVersion();
        switch (version) {
            case V1: {
                DolphinSchedulerV1WorkflowConverter v1Converter = new DolphinSchedulerV1WorkflowConverter((DolphinSchedulerPackage)this.sourcePackageFileService.getPackage(), this.converterProperties);
                this.specifications = v1Converter.convert();
                break;
            }
            case V2: {
                DolphinSchedulerV2WorkflowConverter v2Converter = new DolphinSchedulerV2WorkflowConverter((DolphinSchedulerPackage<Project, DagData, DataSource, com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.ResourceComponent, UdfFunc>)((DolphinSchedulerPackage)this.sourcePackageFileService.getPackage()), this.converterProperties);
                this.specifications = v2Converter.convert();
                break;
            }
            case V3: {
                DolphinSchedulerV3WorkflowConverter v3Converter = new DolphinSchedulerV3WorkflowConverter((DolphinSchedulerPackage<Project, com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData, com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource, ResourceComponent, com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc>)((DolphinSchedulerPackage)this.sourcePackageFileService.getPackage()), this.converterProperties);
                this.specifications = v3Converter.convert();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported version");
            }
        }
    }

    @Override
    public void write() throws Exception {
        File target = ((DataWorksPackage)this.targetPackage).getPackageFile();
        this.doWrite(target);
    }

    public void doWrite(File target) {
        log.info("write workflow package to {}", (Object)target.getAbsolutePath());
        this.clearDir(target);
        for (Specification<DataWorksWorkflowSpec> specification : this.specifications) {
            DataWorksWorkflowSpec spec = (DataWorksWorkflowSpec)specification.getSpec();
            for (SpecWorkflow workflow : spec.getWorkflows()) {
                String workflowName = workflow.getName();
                File workflowFile = new File(target, workflowName);
                if (!workflowFile.exists()) {
                    workflowFile.mkdir();
                }
                File file = new File(workflowFile, ((DataWorksWorkflowSpec)specification.getSpec()).getName() + ".json");
                try {
                    Files.write(file.toPath(), SpecUtil.writeToSpec(specification).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (Exception e) {
                    log.error("write to target file error", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void clearDir(File target) {
        if (target.exists()) {
            try {
                FileUtils.deleteDirectory((File)target);
            }
            catch (Exception e) {
                throw new RuntimeException("delete file " + target.getAbsolutePath() + " failed");
            }
        }
        target.mkdirs();
    }
}

