/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.oozie;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.tenant.EnvType;
import com.aliyun.dataworks.migrationx.domain.dataworks.oozie.FakeElEvaluatorContext;
import com.aliyun.dataworks.migrationx.domain.dataworks.oozie.OozieActionType;
import com.aliyun.dataworks.migrationx.domain.dataworks.oozie.OozieNodeType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.RawNodeType;
import com.aliyun.dataworks.migrationx.transformer.core.common.Constants;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectAssetLoader;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItemType;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportRiskLevel;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DICode;
import com.aliyun.dataworks.migrationx.transformer.core.translator.TranslateUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.DiCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OozieWorkflowConverter
extends AbstractBaseConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OozieWorkflowConverter.class);
    private static final String DEFAULT_DATASOURCE = "odps_first";
    private static final String DEFAULT_DATASOURCE_TYPE = "odps";
    private Map<String, ELEvaluator.Context> contextMap = new ConcurrentHashMap<String, ELEvaluator.Context>();
    private Asset asset;
    private ThreadLocal<List<NodeRelation>> relations = ThreadLocal.withInitial(() -> new ArrayList());
    private Project project;
    private Properties properties;

    public OozieWorkflowConverter() {
        super(AssetType.OOZIE, "OozieWorkflowConverter");
    }

    public OozieWorkflowConverter(AssetType assetType, String name, ProjectAssetLoader projectAssetLoader) {
        super(assetType, name, projectAssetLoader);
    }

    private void loadELFFunctions(ELEvaluator.Context context) {
        try {
            this.extractFunctionsAndConstants(context, new String[]{"wf:id=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_id", "wf:name=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_name", "wf:appPath=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_appPath", "wf:conf=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_conf", "wf:user=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_user", "wf:group=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_group", "wf:callback=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_callback", "wf:transition=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_transition", "wf:lastErrorNode=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_lastErrorNode", "wf:errorCode=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_errorCode", "wf:errorMessage=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_errorMessage", "wf:run=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_run", "wf:actionData=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_actionData", "wf:actionExternalId=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_actionExternalId", "wf:actionTrackerUri=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_actionTrackerUri", "wf:actionExternalStatus=com.alibaba.dataworks.migration.core.oozie.FakeDagELFunctions#wf_actionExternalStatus", "coord:days=org.apache.oozie.coord.CoordELFunctions#ph1_coord_days", "coord:months=org.apache.oozie.coord.CoordELFunctions#ph1_coord_months", "coord:hours=org.apache.oozie.coord.CoordELFunctions#ph1_coord_hours", "coord:minutes=org.apache.oozie.coord.CoordELFunctions#ph1_coord_minutes", "coord:hoursInDay=org.apache.oozie.coord.CoordELFunctions#ph1_coord_hoursInDay_echo", "coord:daysInMonth=org.apache.oozie.coord.CoordELFunctions#ph1_coord_daysInMonth_echo", "coord:tzOffset=org.apache.oozie.coord.CoordELFunctions#ph1_coord_tzOffset_echo", "coord:current=org.apache.oozie.coord.CoordELFunctions#ph1_coord_current_echo", "coord:currentRange=org.apache.oozie.coord.CoordELFunctions#ph1_coord_currentRange_echo", "coord:offset=org.apache.oozie.coord.CoordELFunctions#ph1_coord_offset_echo", "coord:latest=org.apache.oozie.coord.CoordELFunctions#ph1_coord_latest_echo", "coord:latestRange=org.apache.oozie.coord.CoordELFunctions#ph1_coord_latestRange_echo", "coord:future=org.apache.oozie.coord.CoordELFunctions#ph1_coord_future_echo", "coord:futureRange=org.apache.oozie.coord.CoordELFunctions#ph1_coord_futureRange_echo", "coord:formatTime=org.apache.oozie.coord.CoordELFunctions#ph1_coord_formatTime_echo", "coord:epochTime=org.apache.oozie.coord.CoordELFunctions#ph1_coord_epochTime_echo", "coord:conf=org.apache.oozie.coord.CoordELFunctions#coord_conf", "coord:user=org.apache.oozie.coord.CoordELFunctions#coord_user", "coord:absolute=org.apache.oozie.coord.CoordELFunctions#ph1_coord_absolute_echo", "coord:endOfMonths=org.apache.oozie.coord.CoordELFunctions#ph1_coord_endOfMonths_echo", "coord:endOfWeeks=org.apache.oozie.coord.CoordELFunctions#ph1_coord_endOfWeeks_echo", "coord:endOfDays=org.apache.oozie.coord.CoordELFunctions#ph1_coord_endOfDays_echo", "coord:dateTzOffset=org.apache.oozie.coord.CoordELFunctions#ph1_coord_dateTzOffset_echo", "coord:dataIn=org.apache.oozie.coord.CoordELFunctions#ph1_coord_dataIn_echo", "coord:dataOut=org.apache.oozie.coord.CoordELFunctions#ph1_coord_dataOut_echo", "coord:nominalTime=org.apache.oozie.coord.CoordELFunctions#ph1_coord_nominalTime_echo_wrap", "coord:actualTime=org.apache.oozie.coord.CoordELFunctions#ph1_coord_actualTime_echo_wrap", "coord:dateOffset=org.apache.oozie.coord.CoordELFunctions#ph1_coord_dateOffset_echo", "coord:dateTzOffset=org.apache.oozie.coord.CoordELFunctions#ph1_coord_dateTzOffset_echo", "coord:formatTime=org.apache.oozie.coord.CoordELFunctions#ph1_coord_formatTime_echo", "coord:epochTime=org.apache.oozie.coord.CoordELFunctions#ph1_coord_epochTime_echo", "coord:actionId=org.apache.oozie.coord.CoordELFunctions#ph1_coord_actionId_echo", "coord:name=org.apache.oozie.coord.CoordELFunctions#ph1_coord_name_echo", "coord:conf=org.apache.oozie.coord.CoordELFunctions#coord_conf", "coord:user=org.apache.oozie.coord.CoordELFunctions#coord_user", "coord:databaseIn=org.apache.oozie.coord.HCatELFunctions#ph1_coord_databaseIn_echo", "coord:databaseOut=org.apache.oozie.coord.HCatELFunctions#ph1_coord_databaseOut_echo", "coord:tableIn=org.apache.oozie.coord.HCatELFunctions#ph1_coord_tableIn_echo", "coord:tableOut=org.apache.oozie.coord.HCatELFunctions#ph1_coord_tableOut_echo", "coord:dataInPartitionFilter=org.apache.oozie.coord.HCatELFunctions#ph1_coord_dataInPartitionFilter_echo", "coord:dataInPartitionMin=org.apache.oozie.coord.HCatELFunctions#ph1_coord_dataInPartitionMin_echo", "coord:dataInPartitionMax=org.apache.oozie.coord.HCatELFunctions#ph1_coord_dataInPartitionMax_echo", "coord:dataInPartitions=org.apache.oozie.coord.HCatELFunctions#ph1_coord_dataInPartitions_echo", "coord:dataOutPartitions=org.apache.oozie.coord.HCatELFunctions#ph1_coord_dataOutPartitions_echo", "coord:dataOutPartitionValue=org.apache.oozie.coord.HCatELFunctions#ph1_coord_dataOutPartitionValue_echo"}, new String[]{"MINUTE=org.apache.oozie.coord.CoordELConstants#SUBMIT_MINUTE", "HOUR=org.apache.oozie.coord.CoordELConstants#SUBMIT_HOUR", "DAY=org.apache.oozie.coord.CoordELConstants#SUBMIT_DAY", "MONTH=org.apache.oozie.coord.CoordELConstants#SUBMIT_MONTH", "YEAR=org.apache.oozie.coord.CoordELConstants#SUBMIT_YEAR"});
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) {
        this.asset = asset;
        this.properties = this.properties == null && this.propertiesLoader != null ? (Properties)this.propertiesLoader.getResult() : this.properties;
        ArrayList<DwWorkflow> workflowList = new ArrayList<DwWorkflow>();
        File[] workflowDirsArray = asset.getPath().listFiles(f -> f.isDirectory() && !f.isHidden());
        ArrayList<File> workflowDirs = new ArrayList<File>();
        if (workflowDirsArray != null) {
            workflowDirs.addAll(Arrays.asList(workflowDirsArray));
        }
        LOGGER.info("workflowDirs: {}", workflowDirs);
        if (CollectionUtils.isEmpty(workflowDirs) && !new File(asset.getPath(), "workflow.xml").exists()) {
            return workflowList;
        }
        if (CollectionUtils.isEmpty(workflowDirs)) {
            workflowDirs.add(asset.getPath());
        }
        ListUtils.emptyIfNull(workflowDirs).stream().forEach(workflowDir -> {
            DwWorkflow workflow = this.convertOozieWorkflow((File)workflowDir);
            if (workflow != null) {
                workflowList.add(workflow);
                LOGGER.info("found oozie workflow: {}, path: {}", (Object)workflow.getName(), (Object)workflowDir.getAbsolutePath());
            }
        });
        return workflowList;
    }

    private DwWorkflow convertOozieWorkflow(File workflowDir) {
        this.relations.set(new ArrayList());
        String wfxmlFile = workflowDir.getAbsolutePath() + File.separator + "workflow.xml";
        try {
            this.contextMap.put(workflowDir.getAbsolutePath(), (ELEvaluator.Context)new FakeElEvaluatorContext());
            ELEvaluator elEvaluator = new ELEvaluator(this.contextMap.get(workflowDir.getAbsolutePath()));
            this.loadELFFunctions(elEvaluator.getContext());
            String wfxml = IOUtils.toString((InputStream)new FileInputStream(new File(wfxmlFile)));
            String jobProp = workflowDir.getAbsolutePath() + File.separator + "job.properties";
            Properties jobProperties = new Properties();
            if (new File(jobProp).exists()) {
                jobProperties.load(new FileInputStream(new File(jobProp)));
            }
            Element coordApp = this.processCoordinateApp(workflowDir, elEvaluator);
            try {
                wfxml = (String)elEvaluator.evaluate(wfxml, String.class);
            }
            catch (Exception e) {
                LOGGER.error("evaluate xml variables failed: {}", (Object)e.getMessage());
                this.reportException(workflowDir, e);
            }
            Element workflowXml = XmlUtils.parseXml((String)wfxml);
            DwWorkflow workflow = this.parseAndConvertWorkflow(workflowXml, workflowDir.getAbsolutePath(), coordApp);
            this.processWorkflowRelations((Workflow)workflow);
            this.processWorkflowNodeParameters(workflow, jobProperties);
            this.processProjectRootDependency(workflow, coordApp);
            return workflow;
        }
        catch (Exception e) {
            LOGGER.error("parse workflow failed: {}", (Object)e.getMessage());
            this.reportException(workflowDir, e);
            return null;
        }
    }

    private void processProjectRootDependency(DwWorkflow workflow, Element coordApp) throws Exception {
        for (Node node : workflow.getNodes()) {
            node.setCronExpress(this.getCronExpress(coordApp));
            if (!CollectionUtils.isEmpty((Collection)node.getInputs()) || !workflow.getScheduled().booleanValue()) continue;
            node.setInputs(Collections.singletonList(new NodeIo(NodeUtils.getProjectRootOutput((Project)this.project))));
            ListUtils.emptyIfNull((List)node.getInputs()).forEach(in -> in.setParseType(Integer.valueOf(1)));
        }
    }

    private Element processCoordinateApp(File workflowDir, ELEvaluator elEvaluator) throws Exception {
        Element coordApp = null;
        String coordinatorXml = workflowDir.getAbsolutePath() + File.separator + "coordinator.xml";
        if (new File(coordinatorXml).exists()) {
            Element outputEvents;
            Element inputEvents;
            List dataIn;
            String coordXml = IOUtils.toString((InputStream)new FileInputStream(new File(coordinatorXml)));
            coordApp = XmlUtils.parseXml((String)coordXml);
            Element inputLogic = coordApp.getChild("input-logic", coordApp.getNamespace());
            if (inputLogic != null) {
                for (Object logicInObj : inputLogic.getChildren()) {
                    Element logicIn = (Element)logicInObj;
                    dataIn = logicIn.getChildren();
                    if (!CollectionUtils.isNotEmpty((Collection)dataIn)) continue;
                    elEvaluator.setVariable("oozie.dataname." + logicIn.getAttributeValue("name"), (Object)((Element)dataIn.get(0)).getName());
                }
            }
            if ((inputEvents = coordApp.getChild("input-events", coordApp.getNamespace())) != null) {
                for (Object dataInObj : inputEvents.getChildren()) {
                    dataIn = (Element)dataInObj;
                    elEvaluator.setVariable("oozie.dataname." + dataIn.getAttributeValue("name"), (Object)dataIn.getName());
                }
            }
            if ((outputEvents = coordApp.getChild("output-events", coordApp.getNamespace())) != null) {
                for (Object dataOutObj : outputEvents.getChildren()) {
                    Element dataOut = (Element)dataOutObj;
                    elEvaluator.setVariable("oozie.dataname." + dataOut.getAttributeValue("name"), (Object)dataOut.getName());
                }
            }
            coordXml = (String)elEvaluator.evaluate(coordXml, String.class);
            coordApp = XmlUtils.parseXml((String)coordXml);
            this.handleCoordinatorAppAction(workflowDir, elEvaluator.getContext(), coordApp);
        }
        return coordApp;
    }

    private void processWorkflowNodeParameters(DwWorkflow workflow, Properties jobProperties) {
        ListUtils.emptyIfNull((List)workflow.getNodes()).stream().filter(n -> StringUtils.isNotBlank((CharSequence)n.getCode())).forEach(n -> {
            List<String> params = this.parseCodeParameters(n.getCode());
            String nodeParam = Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull(params).stream().map(p -> {
                String value = jobProperties.getProperty((String)p, "UNDEFINED_VARIABLE_VALUE");
                if (!CodeProgramType.DIDE_SHELL.name().equalsIgnoreCase(n.getType())) {
                    return Joiner.on((String)"=").join(p, (Object)value, new Object[0]);
                }
                return value;
            }).collect(Collectors.toList()));
            n.setParameter(nodeParam);
        });
    }

    private void handleCoordinatorAppAction(File workflowDir, ELEvaluator.Context context, Element coordApp) {
        for (Object item : coordApp.getChildren()) {
            Element element = (Element)item;
            try {
                Element configuration;
                Element workflow;
                String appPath;
                File appPathFile;
                OozieNodeType oozieNodeType = OozieNodeType.getOozieNodeType((String)element.getName());
                if (!oozieNodeType.equals((Object)OozieNodeType.ACTION) || !(appPathFile = new File(appPath = (workflow = element.getChild("workflow", element.getNamespace())).getChild("app-path", element.getNamespace()).getTextTrim())).getName().equals(workflowDir.getName()) || (configuration = workflow.getChild("configuration", element.getNamespace())) == null) continue;
                for (Object proObj : configuration.getChildren()) {
                    Element pro = (Element)proObj;
                    String name = pro.getChild("name", element.getNamespace()).getTextTrim();
                    String value = pro.getChild("value", element.getNamespace()).getTextTrim();
                    context.setVariable(name, (Object)value);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private String replaceInvalidChar(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return name.replaceAll("-", "_").replaceAll("\\(", "__").replaceAll("\\)", "__");
    }

    private void reportException(File workflowDir, Exception e) {
        ReportItem reportItem = new ReportItem();
        reportItem.setName(workflowDir.getName());
        reportItem.setType(ReportItemType.OOZIE_TO_DATAWORKS.getName());
        reportItem.setPath(workflowDir.getAbsolutePath());
        reportItem.setMessage(e.getMessage());
        reportItem.setException(ExceptionUtils.getStackTrace((Throwable)e));
        reportItem.setRiskLevel(ReportRiskLevel.ERROR);
        this.reportItems.add(reportItem);
    }

    private void reportException(Workflow workflow, Exception e) {
        ReportItem reportItem = new ReportItem();
        reportItem.setName(String.format("Workflow:%s", workflow.getName()));
        reportItem.setType(ReportItemType.OOZIE_TO_DATAWORKS.getName());
        reportItem.setMessage(e.getMessage());
        reportItem.setException(ExceptionUtils.getStackTrace((Throwable)e));
        reportItem.setRiskLevel(ReportRiskLevel.ERROR);
        this.reportItems.add(reportItem);
    }

    private void reportException(Workflow workflow, Node node, Exception e, ReportItemType reportItemType) {
        ReportItem reportItem = new ReportItem();
        reportItem.setName(String.format("Workflow:%s / Node:%s", workflow.getName(), node.getName()));
        reportItem.setType(reportItemType.getName());
        reportItem.setMessage(e.getMessage());
        reportItem.setException(ExceptionUtils.getStackTrace((Throwable)e));
        reportItem.setRiskLevel(ReportRiskLevel.ERROR);
        this.reportItems.add(reportItem);
    }

    private void processWorkflowRelations(Workflow workflow) {
        for (NodeRelation relation : this.relations.get()) {
            Node nodeFrom = this.getWorkflowNodeByName(workflow, relation.nodeFrom);
            Node nodeTo = this.getWorkflowNodeByName(workflow, relation.nodeTo);
            if (nodeFrom == null || nodeTo == null) {
                LOGGER.debug("node not found, nodeFrom: {}={}, nodeTo: nodeTo={}", new Object[]{relation.nodeFrom, nodeFrom == null, relation.nodeTo, nodeTo == null});
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)nodeFrom.getOutputs())) {
                LOGGER.debug("node {} output is empty", (Object)nodeFrom.getName());
                continue;
            }
            NodeIo input = (NodeIo)nodeFrom.getOutputs().get(0);
            boolean match = ListUtils.emptyIfNull((List)nodeTo.getInputs()).stream().anyMatch(in -> this.isTheSameIo((NodeIo)in, input));
            if (match) continue;
            nodeTo.getInputs().add(input);
        }
    }

    private boolean isTheSameIo(NodeIo a, NodeIo b) {
        if (!a.getData().equalsIgnoreCase(b.getData())) {
            return false;
        }
        return !StringUtils.isNotBlank((CharSequence)a.getRefTableName()) || a.getRefTableName().equalsIgnoreCase(b.getRefTableName());
    }

    private Node getWorkflowNodeByName(Workflow workflow, String nodeName) {
        for (Node node : workflow.getNodes()) {
            if (!node.getName().equalsIgnoreCase(nodeName)) continue;
            return node;
        }
        return null;
    }

    private DwWorkflow parseAndConvertWorkflow(Element workflowXml, String workflowPath, Element coordApp) throws Exception {
        DwWorkflow workflow = new DwWorkflow();
        workflow.setVersion(WorkflowVersion.V3);
        workflow.setName(this.replaceInvalidChar(Joiner.on((String)"_").join((Object)workflowXml.getAttributeValue("name"), (Object)new File(workflowPath).getName(), new Object[0])));
        workflow.setScheduled(Boolean.valueOf(coordApp != null));
        List children = workflowXml.getChildren();
        for (Element child : children) {
            try {
                this.handleWorkflowChild(child, (Workflow)workflow, workflowPath);
            }
            catch (Exception e) {
                LOGGER.error("{}", (Object)e.getMessage());
                this.reportException((Workflow)workflow, e);
            }
        }
        return workflow;
    }

    private List<String> parseCodeParameters(String code) {
        Pattern pattern = Pattern.compile("\\$\\{\\w+\\}");
        Matcher matcher = pattern.matcher(code);
        HashSet<String> params = new HashSet<String>();
        while (matcher.find()) {
            String param = matcher.group();
            param = param.replaceAll("\\$\\{", "").replaceAll("\\}", "");
            params.add(param);
        }
        return new ArrayList<String>(params);
    }

    private void handleWorkflowChild(Element child, Workflow workflow, String workflowPath) throws Exception {
        String type = child.getName();
        OozieNodeType oozieNodeType = OozieNodeType.getOozieNodeType((String)type);
        switch (oozieNodeType) {
            case START: 
            case END: 
            case JOIN: {
                this.addVirtualNode(child, workflow);
                break;
            }
            case KILL: {
                LOGGER.info("skip kill node: {}", (Object)child.toString());
                break;
            }
            case ACTION: {
                this.addActionNode(child, workflow, workflowPath);
                break;
            }
            case FORK: {
                this.addForkNode(child, workflow);
                break;
            }
            default: {
                throw new Exception("unsupported oozie action type: " + type);
            }
        }
    }

    private void addForkNode(Element child, Workflow workflow) {
        DwNode node = new DwNode();
        node.setIsAutoParse(Integer.valueOf(0));
        node.setName(this.replaceInvalidChar(child.getAttribute("name") == null ? child.getName() : child.getAttributeValue("name")));
        node.setOwner(this.project.getOpUser());
        node.setType(CodeProgramType.VIRTUAL.getName());
        node.setStartRightNow(Boolean.valueOf(false));
        node.setPauseSchedule(Boolean.valueOf(false));
        node.setCronExpress("day");
        node.setNodeUseType(BooleanUtils.isTrue((Boolean)workflow.getScheduled()) ? NodeUseType.SCHEDULED : NodeUseType.MANUAL_WORKFLOW);
        NodeIo output = new NodeIo();
        output.setData(NodeUtils.getDefaultNodeOutput((Workflow)workflow, (Node)node));
        output.setParseType(Integer.valueOf(1));
        node.setOutputs(Arrays.asList(output));
        List paths = child.getChildren("path", child.getNamespace());
        for (Element path : paths) {
            String toNode = this.replaceInvalidChar(path.getAttributeValue("start"));
            NodeRelation relation = new NodeRelation();
            relation.nodeFrom = node.getName();
            relation.nodeTo = toNode;
            this.relations.get().add(relation);
        }
        workflow.getNodes().add(node);
    }

    private void addActionNode(Element child, Workflow workflow, String workflowPath) {
        List children = child.getChildren();
        for (Element actionXml : children) {
            try {
                OozieActionType actionType = OozieActionType.getOozieActionType((String)actionXml.getName());
                DwNode node = new DwNode();
                node.setIsAutoParse(Integer.valueOf(0));
                node.setName(this.replaceInvalidChar(child.getAttribute("name") == null ? child.getName() : child.getAttributeValue("name")));
                node.setNodeUseType(BooleanUtils.isTrue((Boolean)workflow.getScheduled()) ? NodeUseType.SCHEDULED : NodeUseType.MANUAL_WORKFLOW);
                node.setRawNodeType(Optional.ofNullable(this.getRawNodeType(actionType)).map(Enum::name).orElse(actionType.getAction()));
                node.setCronExpress("day");
                node.setWorkflowRef(workflow);
                switch (actionType) {
                    case HIVE: 
                    case HIVE2: {
                        this.handleHiveNode(actionXml, (Node)node, workflow, workflowPath);
                        break;
                    }
                    case SQOOP: {
                        this.handleSqoopNode(actionXml, (Node)node, workflow);
                        break;
                    }
                    case SHELL: {
                        this.handleShellNode(actionXml, node, workflow, workflowPath);
                        break;
                    }
                    case OK: {
                        this.handleHiveOk(actionXml);
                        break;
                    }
                    case ERROR: 
                    case EMAIL: {
                        this.handleHiveError(actionXml);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("{}", (Object)e.getMessage());
                this.reportException(workflow, e);
            }
        }
    }

    private RawNodeType getRawNodeType(OozieActionType actionType) {
        switch (actionType) {
            case HIVE: {
                return RawNodeType.OOZIE_HIVE;
            }
            case OK: {
                return RawNodeType.OOZIE_OK;
            }
            case EMAIL: {
                return RawNodeType.OOZIE_EMAIL;
            }
            case ERROR: {
                return RawNodeType.OOZIE_ERROR;
            }
            case HIVE2: {
                return RawNodeType.OOZIE_HIVE2;
            }
            case SHELL: {
                return RawNodeType.OOZIE_SHELL;
            }
            case SQOOP: {
                return RawNodeType.OOZIE_SQOOP;
            }
        }
        return null;
    }

    private void handleShellNode(Element actionXml, DwNode node, Workflow workflow, String workflowPath) {
        try {
            String txt;
            String[] kv;
            String type = this.properties.getProperty("workflow.converter.shellNodeType", CodeProgramType.EMR_SHELL.name());
            node.setType(type);
            node.setOwner(this.project.getOpUser());
            node.setStartRightNow(Boolean.valueOf(false));
            node.setPauseSchedule(Boolean.valueOf(false));
            NodeIo output = new NodeIo();
            output.setData(NodeUtils.getDefaultNodeOutput((Workflow)workflow, (Node)node));
            output.setParseType(Integer.valueOf(1));
            node.setOutputs(Arrays.asList(output));
            FakeElEvaluatorContext context = new FakeElEvaluatorContext();
            Element exec = actionXml.getChild("exec", actionXml.getNamespace());
            List arguments = actionXml.getChildren("argument", actionXml.getNamespace());
            List envVars = actionXml.getChildren("env-var", actionXml.getNamespace());
            LOGGER.info("exec: {}, arguments: {}, envVars: {}", new Object[]{exec, arguments, envVars});
            ArrayList<String> lines = new ArrayList<String>();
            ListUtils.emptyIfNull((List)envVars).stream().forEach(e -> lines.add(e.getTextTrim()));
            lines.add(exec.getTextTrim() + " " + Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull((List)arguments).stream().map(arg -> arg.getTextTrim()).collect(Collectors.toList())));
            String code = Joiner.on((String)"\n").join(lines);
            node.setCode(code);
            node.setCode(EmrCodeUtils.toEmrCode((Node)node));
            if (actionXml.getName().equalsIgnoreCase("param") && (kv = (txt = actionXml.getText().trim()).split("=")).length == 2) {
                context.setVariable(kv[0], (Object)kv[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)node.getCode())) {
                ELEvaluator elEvaluator = new ELEvaluator((ELEvaluator.Context)context);
                code = (String)elEvaluator.evaluate(node.getCode(), String.class);
                node.setCode(code);
            }
            TranslateUtils.translateSparkSubmit(node, this.properties);
            TranslateUtils.translateCommandSql((DwWorkflow)node.getWorkflowRef(), node, this.properties);
            workflow.getNodes().add(node);
        }
        catch (Exception e2) {
            LOGGER.error("{}", (Object)e2.getMessage());
            this.reportException(workflow, (Node)node, e2, ReportItemType.HIVE_SQL_TO_MC_SQL);
        }
    }

    private String getCronExpress(Element coordApp) throws Exception {
        if (coordApp == null) {
            return null;
        }
        String frequency = coordApp.getAttributeValue("frequency");
        Object[] cron = new String[]{"0", "0", "0", "*", "*", "*"};
        if (NumberUtils.isNumber((String)frequency)) {
            Integer minutes = Integer.valueOf(frequency);
            int[] steps = new int[]{1, 60, 1440, 43200};
            for (int i = steps.length - 1; i >= 0; --i) {
                if (minutes / steps[i] <= 0) continue;
                cron[i + 1] = "*/" + minutes / steps[i];
                break;
            }
            return Joiner.on((String)" ").join(cron);
        }
        cron = frequency.split(" ");
        if (cron.length > 6) {
            throw new Exception("invalid cron expression: " + frequency);
        }
        if (cron.length == 6) {
            return Joiner.on((String)" ").join(cron);
        }
        ArrayList<Object> arr = new ArrayList<Object>(Arrays.asList(cron));
        arr.add(0, "0");
        return Joiner.on((String)" ").join(arr);
    }

    private void handleSqoopNode(Element actionXml, Node node, Workflow workflow) {
        try {
            node.setType(CodeProgramType.DI.name());
            node.setOwner(this.project.getOpUser());
            node.setStartRightNow(Boolean.valueOf(false));
            node.setPauseSchedule(Boolean.valueOf(false));
            NodeIo output = new NodeIo();
            output.setData(NodeUtils.getDefaultNodeOutput((Workflow)workflow, (Node)node));
            output.setParseType(Integer.valueOf(1));
            node.setOutputs(Arrays.asList(output));
            String defaultDatasource = this.properties.getProperty("workflow.converter.target.engine.datasource.name", DEFAULT_DATASOURCE);
            String defaultDatasourceType = this.properties.getProperty("workflow.converter.target.engine.datasource.type", DEFAULT_DATASOURCE_TYPE);
            CalcEngineType engineType = CalcEngineType.valueOf((String)this.properties.getProperty("workflow.converter.target.engine.type", CalcEngineType.ODPS.name()));
            DICode code = DICode.parseDiCode(actionXml, engineType, defaultDatasource, defaultDatasourceType);
            List<DwDatasource> datasourceList = DiCodeUtils.processSqoopDatasource(code);
            ListUtils.emptyIfNull(datasourceList).stream().forEach(ds -> {
                ds.setProjectRef(this.project);
                ds.setEnvType(EnvType.PRD.name());
                if (this.project.getDatasources().stream().noneMatch(d -> d.getName().equals(ds.getName()))) {
                    this.project.getDatasources().add(ds);
                }
            });
            if (ReportRiskLevel.ERROR.equals((Object)code.getRiskLevel())) {
                node.setType(CodeProgramType.VIRTUAL.name());
                XMLOutputter xmlOutputter = new XMLOutputter();
                String xmlCode = xmlOutputter.outputString(actionXml);
                node.setCode(xmlCode);
                this.reportException(workflow, node, new RuntimeException(code.getException()), ReportItemType.SQOOP_TO_DW_DI);
            } else {
                node.setCode(code.getCode());
            }
            workflow.getNodes().add(node);
        }
        catch (Exception e) {
            LOGGER.error("{}", (Throwable)e);
            this.reportException(workflow, node, e, ReportItemType.SQOOP_TO_DW_DI);
        }
    }

    private void handleHiveError(Element actionXml) {
        String toNode = this.replaceInvalidChar(actionXml.getAttributeValue("to"));
        if (StringUtils.isNotBlank((CharSequence)toNode)) {
            NodeRelation relation = new NodeRelation();
            relation.nodeFrom = this.replaceInvalidChar(actionXml.getParentElement().getAttributeValue("name"));
            relation.nodeTo = toNode;
            this.relations.get().add(relation);
        }
    }

    private void handleHiveOk(Element actionXml) {
        String toNode = this.replaceInvalidChar(actionXml.getAttributeValue("to"));
        if (StringUtils.isNotBlank((CharSequence)toNode)) {
            NodeRelation relation = new NodeRelation();
            relation.nodeFrom = this.replaceInvalidChar(actionXml.getParentElement().getAttributeValue("name"));
            relation.nodeTo = toNode;
            this.relations.get().add(relation);
        }
    }

    private void handleHiveNode(Element actionXml, Node node, Workflow workflow, String workflowPath) {
        try {
            String hiveNodeType = this.properties.getProperty("workflow.converter.sqlNodeType", CodeProgramType.EMR_HIVE.name());
            node.setType(CodeProgramType.valueOf((String)hiveNodeType).name());
            node.setOwner(this.project.getOpUser());
            node.setStartRightNow(Boolean.valueOf(false));
            node.setPauseSchedule(Boolean.valueOf(false));
            NodeIo output = new NodeIo();
            output.setData(NodeUtils.getDefaultNodeOutput((Workflow)workflow, (Node)node));
            output.setParseType(Integer.valueOf(1));
            node.setOutputs(Arrays.asList(output));
            List children = actionXml.getChildren();
            FakeElEvaluatorContext context = new FakeElEvaluatorContext();
            for (Element element : children) {
                String txt;
                String[] kv;
                if (element.getName().equalsIgnoreCase("script")) {
                    String scriptFile = element.getText().trim();
                    File scriptPath = new File(workflowPath + File.separator + scriptFile);
                    String code = scriptPath.exists() ? FileUtils.readFileToString((File)scriptPath, (String)"utf-8") : scriptFile;
                    node.setCode(code);
                    node.setCode(EmrCodeUtils.toEmrCode(node));
                    node.setRef(Constants.WORKFLOWS_DIR_PRJ_RELATED + File.separator + workflow.getName() + File.separator + "nodes" + File.separator + node.getName() + File.separator + scriptFile);
                }
                if (!element.getName().equalsIgnoreCase("param") || (kv = (txt = element.getText().trim()).split("=")).length != 2) continue;
                context.setVariable(kv[0], (Object)kv[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)node.getCode())) {
                ELEvaluator elEvaluator = new ELEvaluator((ELEvaluator.Context)context);
                String code = (String)elEvaluator.evaluate(node.getCode(), String.class);
                node.setCode(code);
            }
            workflow.getNodes().add(node);
        }
        catch (Exception e) {
            LOGGER.error("{}", (Object)e.getMessage());
            this.reportException(workflow, node, e, ReportItemType.HIVE_SQL_TO_MC_SQL);
        }
    }

    private void addVirtualNode(Element child, Workflow workflow) throws Exception {
        OozieNodeType oozieNodeType = OozieNodeType.getOozieNodeType((String)child.getName());
        DwNode node = new DwNode();
        node.setIsAutoParse(Integer.valueOf(0));
        node.setName(this.replaceInvalidChar(child.getAttribute("name") == null ? child.getName() : child.getAttributeValue("name")));
        node.setOwner(this.project.getOpUser());
        node.setType(CodeProgramType.VIRTUAL.getName());
        node.setRawNodeType(Optional.ofNullable(this.getRawNodeType(oozieNodeType)).map(Enum::name).orElse(oozieNodeType.getType()));
        node.setStartRightNow(Boolean.valueOf(false));
        node.setPauseSchedule(Boolean.valueOf(false));
        node.setCronExpress("day");
        node.setNodeUseType(BooleanUtils.isTrue((Boolean)workflow.getScheduled()) ? NodeUseType.SCHEDULED : NodeUseType.MANUAL_WORKFLOW);
        NodeIo output = new NodeIo();
        output.setData(NodeUtils.getDefaultNodeOutput((Workflow)workflow, (Node)node));
        output.setParseType(Integer.valueOf(1));
        node.setOutputs(Collections.singletonList(output));
        String toNode = this.replaceInvalidChar(child.getAttributeValue("to"));
        if (StringUtils.isNotBlank((CharSequence)toNode)) {
            NodeRelation relation = new NodeRelation();
            relation.nodeFrom = node.getName();
            relation.nodeTo = toNode;
            this.relations.get().add(relation);
        }
        workflow.getNodes().add(node);
    }

    private RawNodeType getRawNodeType(OozieNodeType oozieNodeType) {
        switch (oozieNodeType) {
            case JOIN: {
                return RawNodeType.OOZIE_JOIN;
            }
            case FORK: {
                return RawNodeType.OOZIE_FORK;
            }
            case END: {
                return RawNodeType.OOZIE_END;
            }
            case KILL: {
                return RawNodeType.OOZIE_KILL;
            }
            case START: {
                return RawNodeType.OOZIE_START;
            }
        }
        return null;
    }

    private static String[] parseDefinition(String str) throws ServiceException {
        try {
            str = str.trim();
            if (!str.contains(":")) {
                str = ":" + str;
            }
            String[] parts = str.split(":");
            String prefix = parts[0];
            parts = parts[1].split("=");
            String name = parts[0];
            parts = parts[1].split("#");
            String klass = parts[0];
            String method = parts[1];
            return new String[]{prefix, name, klass, method};
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0110, new Object[]{str, ex.getMessage(), ex});
        }
    }

    private void extractFunctionsAndConstants(ELEvaluator.Context context, String[] functions, String[] constants) throws ServiceException {
        String[] parts;
        for (String function : functions) {
            parts = OozieWorkflowConverter.parseDefinition(function);
            Method method = this.findMethod(parts[2], parts[3]);
            context.addFunction(parts[0], parts[1], method);
        }
        for (String constant : constants) {
            parts = OozieWorkflowConverter.parseDefinition(constant);
            Object value = OozieWorkflowConverter.findConstant(parts[2], parts[3]);
            context.setVariable(parts[1], value);
        }
    }

    public static Object findConstant(String className, String constantName) throws ServiceException {
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(className);
            Field field = klass.getField(constantName);
            if ((field.getModifiers() & 9) != 9) {
                throw new ServiceException(ErrorCode.E0114, new Object[]{className, constantName});
            }
            return field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new ServiceException(ErrorCode.E0115, new Object[]{className, constantName});
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ErrorCode.E0113, new Object[]{className});
        }
    }

    private Method findMethod(String className, String methodName) throws ServiceException {
        Method method = null;
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(className);
            for (Method m : klass.getMethods()) {
                if (!m.getName().equals(methodName)) continue;
                method = m;
                break;
            }
            if (method == null) {
                throw new ServiceException(ErrorCode.E0111, new Object[]{className, methodName});
            }
            if ((method.getModifiers() & 9) != 9) {
                throw new ServiceException(ErrorCode.E0112, new Object[]{className, methodName});
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ErrorCode.E0113, new Object[]{className});
        }
        return method;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    class NodeRelation {
        public String nodeFrom;
        public String nodeTo;

        NodeRelation() {
        }
    }
}

