/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters.AbstractParameterConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrParameterConverter
extends AbstractParameterConverter<MapReduceParameters> {
    private static final Logger log = LoggerFactory.getLogger(MrParameterConverter.class);
    public static final String MR_YARN_QUEUE = "mapreduce.job.queuename";

    public MrParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        SpecScript script = new SpecScript();
        String type = this.getConverterType();
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String code = this.convertCode(codeProgramType, this.taskDefinition.getName());
        code = this.replaceCodeWithParams(code, specVariableList);
        script.setContent(code);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        this.postHandle("MR", script);
    }

    public String convertCode(CodeProgramType type, String taskName) {
        if (type.name().startsWith("EMR")) {
            String code = this.buildCommand((MapReduceParameters)this.parameter);
            return code;
        }
        if (type.name().startsWith("ODPS")) {
            List resources = ListUtils.emptyIfNull((List)((MapReduceParameters)this.parameter).getResourceFilesList()).stream().filter(Objects::nonNull).map(ResourceInfo::getResourceName).filter(name -> StringUtils.isNotEmpty((CharSequence)name)).distinct().collect(Collectors.toList());
            ArrayList<String> codeLines = new ArrayList<String>();
            codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)type, (String)"", resources));
            OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
            odpsSparkCode.setResourceReferences(codeLines);
            odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
            odpsSparkCode.getSparkJson().setMainClass(((MapReduceParameters)this.parameter).getMainClass());
            odpsSparkCode.getSparkJson().setVersion("2.x");
            odpsSparkCode.getSparkJson().setLanguage("java");
            odpsSparkCode.getSparkJson().setMainJar(((MapReduceParameters)this.parameter).getMainJar().getResourceName());
            odpsSparkCode.getSparkJson().setArgs(((MapReduceParameters)this.parameter).getMainArgs());
            return odpsSparkCode.toString();
        }
        throw new RuntimeException("not support type " + type);
    }

    private String buildCommand(MapReduceParameters mapreduceParameters) {
        List<String> args = MrParameterConverter.buildArgs(mapreduceParameters);
        String command = String.join((CharSequence)" ", args);
        return command;
    }

    private static List<String> buildArgs(MapReduceParameters param) {
        String mainArgs;
        String yarnQueue;
        String others;
        String appName;
        String resourceName;
        ArrayList<String> args = new ArrayList<String>();
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null && StringUtils.isNotEmpty((CharSequence)(resourceName = mainJar.getResourceName()))) {
            String[] resourceNames = resourceName.split("/");
            if (resourceNames.length > 0) {
                resourceName = resourceNames[resourceNames.length - 1];
            }
            String resource = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.EMR_MR, (String)"", Arrays.asList(resourceName));
            args.add(resource + resourceName);
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add(mainClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.name", ArgsUtils.escape((String)appName)));
        }
        if ((StringUtils.isEmpty((CharSequence)(others = param.getOthers())) || !others.contains(MR_YARN_QUEUE)) && StringUtils.isNotEmpty((CharSequence)(yarnQueue = param.getYarnQueue()))) {
            args.add(String.format("%s%s=%s", "-D", MR_YARN_QUEUE, yarnQueue));
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.mrNodeType");
        String defaultConvertType = CodeProgramType.EMR_MR.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

