/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.hivecli.HiveCliParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow.parameters.AbstractParameterConverter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class HiveCliParameterConverter
extends AbstractParameterConverter<HiveCliParameters> {
    public HiveCliParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        String cmd;
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        this.convertFileResourceList(specNode);
        SpecScript script = new SpecScript();
        String hiveType = ((HiveCliParameters)this.parameter).getHiveCliTaskExecutionType();
        String type = "SCRIPT".equals(hiveType) ? this.getScriptConverterType() : this.getConverterType();
        CodeProgramType codeProgramType = CodeProgramType.getNodeTypeByName((String)type);
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        String code = cmd = this.buildCommand(codeProgramType, (HiveCliParameters)this.parameter);
        String resourceReference = this.buildFileResourceReference(specNode, "##");
        code = this.replaceCodeWithParams(code, specVariableList);
        script.setContent(resourceReference + code);
        script.setContent(code);
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        this.postHandle("HIVECLI", script);
    }

    @Override
    protected String buildFileResourceReference(SpecNode specNode, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        Optional.ofNullable(specNode).map(SpecNode::getFileResources).ifPresent(fileResources -> fileResources.forEach(fileResource -> stringBuilder.append(String.format("%s@resource_reference{\"%s\"}", prefix, fileResource.getName())).append("\n")));
        return stringBuilder.append("\n").toString();
    }

    private String buildCommand(CodeProgramType codeProgramType, HiveCliParameters hiveCliParameters) {
        String type = hiveCliParameters.getHiveCliTaskExecutionType();
        String resName = "";
        if ("FILE".equals(type)) {
            List resourceInfos = hiveCliParameters.getResourceList();
            if (resourceInfos != null && resourceInfos.size() > 0) {
                resName = ((ResourceInfo)resourceInfos.get(0)).getResourceName();
            }
        } else {
            if ("SCRIPT".equals(type)) {
                String sqlContent = hiveCliParameters.getHiveSqlScript();
                return sqlContent;
            }
            resName = Joiner.on((String)"_").join((Object)this.processDefinition.getName(), (Object)this.taskDefinition.getName(), new Object[0]) + ".sql";
        }
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<String> resources = new ArrayList<String>();
        resources.add(resName);
        String resourceRef = DataStudioCodeUtils.addResourceReference((CodeProgramType)codeProgramType, (String)"", resources);
        args.add(resourceRef + "hive -f");
        args.add(resName);
        String hiveCliOptions = hiveCliParameters.getHiveCliOptions();
        if (StringUtils.isNotEmpty((CharSequence)hiveCliOptions)) {
            args.add(hiveCliOptions);
        }
        String command = String.join((CharSequence)" ", args);
        return command;
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.hiveCliNodeType");
        String defaultConvertType = CodeProgramType.EMR_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }

    private String getScriptConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.hiveCliScriptNodeType");
        if (convertType == null) {
            convertType = this.properties.getProperty("workflow.converter.hiveCliNodeType");
        }
        String defaultConvertType = CodeProgramType.EMR_HIVE.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

