/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.workflow;

import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecArtifact;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DolphinSchedulerV3Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.ProcessTaskRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecFlowDependConverter {
    private static final Logger log = LoggerFactory.getLogger(SpecFlowDependConverter.class);
    private static final Map<ArtifactType, Class<? extends SpecArtifact>> ARTIFACT_TYPE_CLASS_MAP = new EnumMap<ArtifactType, Class<? extends SpecArtifact>>(ArtifactType.class);
    private final DataWorksWorkflowSpec spec;
    private final SpecWorkflow specWorkflow;
    private final List<ProcessTaskRelation> processTaskRelationList;

    public SpecFlowDependConverter(DataWorksWorkflowSpec spec, SpecWorkflow specWorkflow, List<ProcessTaskRelation> processTaskRelationList) {
        this.spec = spec;
        this.specWorkflow = specWorkflow;
        this.processTaskRelationList = processTaskRelationList;
    }

    public List<SpecFlowDepend> convert() {
        if (Objects.nonNull(this.specWorkflow)) {
            this.specWorkflow.setDependencies(this.convertTaskRelationList(this.processTaskRelationList));
            return this.specWorkflow.getDependencies();
        }
        this.spec.setFlow(this.convertTaskRelationList(this.processTaskRelationList));
        return this.spec.getFlow();
    }

    private List<SpecFlowDepend> convertTaskRelationList(List<ProcessTaskRelation> taskRelationList) {
        List flow = Optional.ofNullable(this.specWorkflow).map(SpecWorkflow::getDependencies).orElse(Optional.ofNullable(this.spec).map(DataWorksWorkflowSpec::getFlow).orElse(new ArrayList()));
        Map<String, List> nodeIdDependMap = flow.stream().collect(Collectors.toMap(o -> o.getNodeId().getId(), SpecFlowDepend::getDepends));
        Map taskCodeNodeDataMap = DolphinSchedulerV3Context.getContext().getTaskCodeNodeDataMap();
        Map taskCodeNodeIdMap = DolphinSchedulerV3Context.getContext().getTaskCodeNodeIdMap();
        for (ProcessTaskRelation processTaskRelation : ListUtils.emptyIfNull(taskRelationList)) {
            SpecNode currentNode;
            long preTaskCode = processTaskRelation.getPreTaskCode();
            if (preTaskCode == 0L) continue;
            long postTaskCode = processTaskRelation.getPostTaskCode();
            String nodeId = (String)taskCodeNodeIdMap.get(postTaskCode);
            if (nodeId == null) {
                log.warn("can not find nodeId {}", (Object)postTaskCode);
                continue;
            }
            SpecNode finalCurrentNode = currentNode = (SpecNode)this.specWorkflow.getNodes().stream().filter(node -> nodeId.equals(node.getId())).findAny().orElse(null);
            String data = (String)taskCodeNodeDataMap.get(preTaskCode);
            if (data == null) continue;
            this.specWorkflow.getNodes().stream().filter(node -> CollectionUtils.emptyIfNull((Collection)node.getOutputs()).stream().map(output -> (SpecNodeOutput)output).anyMatch(output -> data.equals(output.getData()))).findAny().ifPresent(node -> {
                SpecNodeOutput specNodeOutput = (SpecNodeOutput)node.getOutputs().get(0);
                SpecDepend specDepend = new SpecDepend(null, DependencyType.NORMAL, specNodeOutput);
                SpecFlowDepend specFlowDepend = new SpecFlowDepend();
                specFlowDepend.setDepends(Arrays.asList(specDepend));
                specFlowDepend.setNodeId(finalCurrentNode);
                this.specWorkflow.getDependencies().add(specFlowDepend);
            });
        }
        return flow;
    }

    static {
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.TABLE, SpecTable.class);
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.VARIABLE, SpecVariable.class);
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.NODE_OUTPUT, SpecNodeOutput.class);
        ARTIFACT_TYPE_CLASS_MAP.put(ArtifactType.FILE, SpecArtifact.class);
    }
}

