/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrParameterConverter
extends AbstractParameterConverter<MapReduceParameters> {
    private static final Logger log = LoggerFactory.getLogger(MrParameterConverter.class);
    public static final String MR_YARN_QUEUE = "mapreduce.job.queuename";

    public MrParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String type = this.getConverterType();
        dwNode.setType(type);
        dwNode.setParameter(Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull((List)((MapReduceParameters)this.parameter).getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.toList())));
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_MR.name(), (CharSequence)dwNode.getType())) {
            String cmd = this.buildCommand((MapReduceParameters)this.parameter);
            cmd = this.replaceCode(cmd, dwNode);
            dwNode.setCode(cmd);
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.ODPS_MR.name(), (CharSequence)dwNode.getType())) {
            List resources = ListUtils.emptyIfNull((List)((MapReduceParameters)this.parameter).getResourceFilesList()).stream().filter(Objects::nonNull).map(ResourceInfo::getResourceName).filter(name -> StringUtils.isNotEmpty((CharSequence)name)).distinct().collect(Collectors.toList());
            ArrayList<String> codeLines = new ArrayList<String>();
            codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resources));
            String command = Joiner.on((String)" ").join((Object)"jar", (Object)"-resources", new Object[]{Optional.ofNullable(((MapReduceParameters)this.parameter).getMainJar().getResourceName()).orElse(""), "-classpath", Joiner.on((String)",").join(resources), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainClass()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainArgs()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getOthers()).orElse("")});
            codeLines.add(command);
            String code = Joiner.on((String)"\n").join(codeLines);
            code = this.replaceCode(code, dwNode);
            dwNode.setCode(code);
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
            EmrCode emrCode = EmrCodeUtils.asEmrCode((Node)dwNode);
            Optional.ofNullable(emrCode).map(EmrCode::getLauncher).map(EmrLauncher::getAllocationSpec).map(EmrAllocationSpec::of).ifPresent(spec -> {
                spec.setQueue(((MapReduceParameters)this.parameter).getYarnQueue());
                emrCode.getLauncher().setAllocationSpec(spec.toMap());
            });
        } else {
            throw new RuntimeException("not support type " + type);
        }
        return Arrays.asList(dwNode);
    }

    private String buildCommand(MapReduceParameters mapreduceParameters) {
        List<String> args = MrParameterConverter.buildArgs(mapreduceParameters);
        String command = String.join((CharSequence)" ", args);
        log.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    private static List<String> buildArgs(MapReduceParameters param) {
        String mainArgs;
        String yarnQueue;
        String others;
        String appName;
        String resourceName;
        ArrayList<String> args = new ArrayList<String>();
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null && StringUtils.isNotEmpty((CharSequence)(resourceName = mainJar.getResourceName()))) {
            String[] resourceNames = resourceName.split("/");
            if (resourceNames.length > 0) {
                resourceName = resourceNames[resourceNames.length - 1];
            }
            String resource = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.EMR_MR, (String)"", Arrays.asList(resourceName));
            args.add(resource + resourceName);
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add(mainClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.name", ArgsUtils.escape((String)appName)));
        }
        if ((StringUtils.isEmpty((CharSequence)(others = param.getOthers())) || !others.contains(MR_YARN_QUEUE)) && StringUtils.isNotEmpty((CharSequence)(yarnQueue = param.getYarnQueue()))) {
            args.add(String.format("%s%s=%s", "-D", MR_YARN_QUEUE, yarnQueue));
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.mrNodeType");
        String defaultConvertType = CodeProgramType.EMR_MR.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

