/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.hivecli.HiveCliParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.ResourceType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v3.nodes.parameters.AbstractParameterConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCliParameterConverter
extends AbstractParameterConverter<HiveCliParameters> {
    private static final Logger log = LoggerFactory.getLogger(HiveCliParameterConverter.class);
    private boolean isEmr;

    public HiveCliParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String executionType = ((HiveCliParameters)this.parameter).getHiveCliTaskExecutionType();
        String type = "SCRIPT".equals(executionType) ? this.getScriptConverterType() : this.getConverterType();
        this.isEmr = this.isEmr(type);
        dwNode.setType(type);
        Map<String, String> resourceMap = this.handleResourcesReference();
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (resourceMap != null) {
            resourceNames.addAll(resourceMap.values());
        }
        String code = this.buildCommand((HiveCliParameters)this.parameter, dwNode, resourceNames);
        code = this.replaceCode(code, dwNode);
        code = this.replaceResourceFullName(resourceMap, code);
        dwNode.setCode(code);
        dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        return Arrays.asList(dwNode);
    }

    private String buildCommand(HiveCliParameters hiveCliParameters, DwNode dwNode, List<String> resourceNames) throws IOException {
        String type = hiveCliParameters.getHiveCliTaskExecutionType();
        String resName = "";
        if ("FILE".equals(type)) {
            List resourceInfos = hiveCliParameters.getResourceList();
            if (resourceInfos != null && resourceInfos.size() > 0) {
                resName = ((ResourceInfo)resourceInfos.get(0)).getResourceName();
            }
            resourceNames.add(resName);
        } else {
            if ("SCRIPT".equals(type)) {
                String sqlContent = hiveCliParameters.getHiveSqlScript();
                return sqlContent;
            }
            String sqlContent = hiveCliParameters.getHiveSqlScript();
            resName = this.generateSqlScriptFile(sqlContent);
            resourceNames.add(resName);
        }
        ArrayList<String> args = new ArrayList<String>();
        String resourceRef = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resourceNames);
        args.add(resourceRef + "hive -f");
        args.add(resName);
        String hiveCliOptions = hiveCliParameters.getHiveCliOptions();
        if (StringUtils.isNotEmpty((CharSequence)hiveCliOptions)) {
            args.add(hiveCliOptions);
        }
        String command = String.join((CharSequence)" ", args);
        return command;
    }

    private String generateSqlScriptFile(String rawScript) throws IOException {
        DwResource pyRes = new DwResource();
        pyRes.setName(Joiner.on((String)"_").join((Object)this.processMeta.getName(), (Object)this.taskDefinition.getName(), new Object[0]) + ".sql");
        pyRes.setWorkflowRef(this.dwWorkflow);
        this.dwWorkflow.getResources().add(pyRes);
        ArrayList<String> paths = new ArrayList<String>();
        DataWorksTransformerConfig config = DataWorksTransformerConfig.getConfig();
        if (config != null) {
            if (this.isEmr) {
                paths.add(CalcEngineType.EMR.getDisplayName(config.getLocale()));
            } else {
                paths.add(CalcEngineType.ODPS.getDisplayName(config.getLocale()));
            }
            paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
        } else {
            if (this.isEmr) {
                paths.add(CalcEngineType.EMR.getDisplayName(Locale.SIMPLIFIED_CHINESE));
            } else {
                paths.add(CalcEngineType.ODPS.getDisplayName(Locale.SIMPLIFIED_CHINESE));
            }
            paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
        }
        pyRes.setFolder(Joiner.on((String)File.separator).join(paths));
        if (this.isEmr) {
            pyRes.setType(CodeProgramType.EMR_FILE.name());
        } else {
            pyRes.setType(CodeProgramType.ODPS_FILE.name());
        }
        pyRes.setExtend(ResourceType.FILE.name());
        File tmpFIle = new File(FileUtils.getTempDirectory(), pyRes.getName());
        FileUtils.writeStringToFile((File)tmpFIle, (String)rawScript, (Charset)StandardCharsets.UTF_8);
        pyRes.setLocalPath(tmpFIle.getAbsolutePath());
        return pyRes.getName();
    }

    private boolean isEmr(String type) {
        return CodeProgramType.EMR_SHELL.name().equals(type) || CodeProgramType.EMR_HIVE.name().equals(type);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.hiveCliNodeType");
        String defaultConvertType = CodeProgramType.EMR_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }

    private String getScriptConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.hiveCliScriptNodeType");
        if (convertType == null) {
            convertType = this.properties.getProperty("workflow.converter.hiveCliNodeType");
        }
        String defaultConvertType = CodeProgramType.EMR_HIVE.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

