/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecBranch;
import com.aliyun.dataworks.common.spec.domain.noref.SpecBranches;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.switchtask.SwitchParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.switchtask.SwitchResultVo;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.workflow.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchParameterConverter
extends AbstractParameterConverter<SwitchParameters> {
    private static final Logger log = LoggerFactory.getLogger(SwitchParameterConverter.class);

    public SwitchParameterConverter(Properties properties, SpecWorkflow specWorkflow, DagData processMeta, TaskDefinition taskDefinition) {
        super(properties, specWorkflow, processMeta, taskDefinition);
    }

    @Override
    protected void convertParameter(SpecNode specNode) {
        List<SpecVariable> specVariableList = this.convertSpecNodeParam(specNode);
        CodeProgramType codeProgramType = CodeProgramType.CONTROLLER_BRANCH;
        SpecScript script = new SpecScript();
        String language = this.codeToLanguageIdentifier(codeProgramType);
        script.setLanguage(language);
        SpecScriptRuntime runtime = new SpecScriptRuntime();
        runtime.setEngine(codeProgramType.getCalcEngineType().getLabel());
        runtime.setCommand(codeProgramType.getName());
        script.setRuntime(runtime);
        script.setPath(this.getScriptPath(specNode));
        script.setParameters(ListUtils.emptyIfNull(specVariableList).stream().filter(v -> !VariableType.NODE_OUTPUT.equals((Object)v.getType())).collect(Collectors.toList()));
        specNode.setScript(script);
        List<SpecBranches> branchList = this.convertCode();
        SpecBranch branch = new SpecBranch();
        branch.setBranches(branchList);
        specNode.setBranch(branch);
        this.postHandle("SWITCH", script);
    }

    public List<SpecBranches> convertCode() {
        JsonNode param = (JsonNode)JSONUtils.parseObject((String)this.taskDefinition.getTaskParams(), JsonNode.class);
        SwitchParameters switchParameters = null;
        if (param.get("switchResult") != null) {
            switchParameters = (SwitchParameters)JSONUtils.parseObject((JsonNode)param.get("switchResult"), SwitchParameters.class);
        }
        if (switchParameters == null || switchParameters.getDependTaskList() == null || switchParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)this.taskDefinition.getTaskParams());
            return null;
        }
        Long defaultNextCode = switchParameters.getNextNode();
        ArrayList<SpecBranches> branchList = new ArrayList<SpecBranches>();
        for (SwitchResultVo switchResultVo : switchParameters.getDependTaskList()) {
            String condition = switchResultVo.getCondition();
            Long nextNodeCode = switchResultVo.getNextNode();
            TaskDefinition branchTask = (TaskDefinition)DolphinSchedulerV2Context.getContext().getTaskCodeMap().get(nextNodeCode);
            if (branchTask == null) continue;
            SpecBranches b = new SpecBranches();
            SpecNodeOutput output = new SpecNodeOutput();
            output.setData(String.valueOf(branchTask.getCode()));
            b.setOutput(output);
            b.setWhen(condition);
            branchList.add(b);
        }
        return branchList;
    }
}

