/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.sql.SqlParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParameterConverter
extends AbstractParameterConverter<SqlParameters> {
    private static final Logger log = LoggerFactory.getLogger(SqlParameterConverter.class);

    public SqlParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        String sqlNodeMapStr = this.converterContext.getProperties().getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<String, String>>(){}.getType());
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String codeProgramType = Optional.ofNullable(sqlTypeNodeTypeMapping).map(s -> (String)s.get(((SqlParameters)this.parameter).getType())).orElseGet(() -> {
            if (DbType.HIVE.name().equalsIgnoreCase(((SqlParameters)this.parameter).getType())) {
                return CodeProgramType.EMR_HIVE.name();
            }
            if (DbType.SPARK.name().equalsIgnoreCase(((SqlParameters)this.parameter).getType())) {
                return CodeProgramType.EMR_SPARK.name();
            }
            if (DbType.ofType((String)((SqlParameters)this.parameter).getType()) != null) {
                return ((SqlParameters)this.parameter).getType();
            }
            String defaultNodeTypeIfNotSupport = this.getSQLConverterType();
            log.warn("using default node Type {} for node {}", (Object)defaultNodeTypeIfNotSupport, (Object)dwNode.getName());
            return defaultNodeTypeIfNotSupport;
        });
        dwNode.setType(codeProgramType);
        dwNode.setConnection(this.getConnectionName(codeProgramType));
        String code = ((SqlParameters)this.parameter).getSql();
        code = this.replaceCode(code, dwNode);
        Map<String, String> resourceMap = this.handleResourcesReference();
        code = this.replaceResourceFullName(resourceMap, code);
        dwNode.setCode(code);
        if (CodeProgramType.EMR_HIVE.name().equals(codeProgramType) || CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        }
        return Arrays.asList(dwNode);
    }

    private String getConnectionName(String codeProgramType) {
        String mappingJson = this.converterContext.getProperties().getProperty("workflow.converter.connection.mapping");
        if (StringUtils.isNotEmpty((String)mappingJson)) {
            Map connectionMapping = (Map)JSONUtils.parseObject((String)mappingJson, Map.class);
            if (connectionMapping == null) {
                log.error("parse connection mapping with {} error", (Object)mappingJson);
            } else {
                String connectionName = (String)connectionMapping.get(codeProgramType);
                log.info("Got connectionName {} by {}", (Object)connectionName, (Object)codeProgramType);
                return connectionName;
            }
        }
        if (!CodeProgramType.EMR_HIVE.name().equals(codeProgramType) && !CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            List datasources = DolphinSchedulerV2Context.getContext().getDataSources();
            if (((SqlParameters)this.parameter).getDatasource() > 0) {
                return CollectionUtils.emptyIfNull((Collection)datasources).stream().filter(s -> s.getId() == ((SqlParameters)this.parameter).getDatasource()).findFirst().map(s -> s.getName()).orElse(null);
            }
        }
        return null;
    }

    private String getSQLConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.commandSqlAs");
        return this.getConverterType(convertType, CodeProgramType.SQL_COMPONENT.name());
    }
}

