/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.procedure.ProcedureParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public class ProcedureParameterConverter
extends AbstractParameterConverter<ProcedureParameters> {
    public ProcedureParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        String sqlNodeMapStr = this.converterContext.getProperties().getProperty("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", "{}");
        Map sqlTypeNodeTypeMapping = (Map)GsonUtils.fromJsonString((String)sqlNodeMapStr, (Type)new TypeToken<Map<String, DbType>>(){}.getType());
        sqlTypeNodeTypeMapping = Optional.ofNullable(sqlTypeNodeTypeMapping).orElse(new HashMap(1));
        String defaultNodeTypeIfNotSupport = this.getConverterType();
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        DbType codeProgramType = (DbType)sqlTypeNodeTypeMapping.get(((ProcedureParameters)this.parameter).getType());
        dwNode.setType(Optional.ofNullable(codeProgramType).map(Enum::name).orElse(defaultNodeTypeIfNotSupport));
        List datasources = DolphinSchedulerV2Context.getContext().getDataSources();
        if (((ProcedureParameters)this.parameter).getDatasource() > 0) {
            CollectionUtils.emptyIfNull((Collection)datasources).stream().filter(s -> s.getId() == ((ProcedureParameters)this.parameter).getDatasource()).findFirst().ifPresent(s -> dwNode.setConnection(s.getName()));
        }
        dwNode.setCode(((ProcedureParameters)this.parameter).getMethod());
        return Arrays.asList(dwNode);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.target.unknownNodeTypeAs");
        return this.getConverterType(convertType, CodeProgramType.VIRTUAL.name());
    }
}

