/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerV2Context;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.enums.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.utils.ParameterUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrParameterConverter
extends AbstractParameterConverter<MapReduceParameters> {
    private static final Logger log = LoggerFactory.getLogger(MrParameterConverter.class);

    public MrParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        Optional.ofNullable((MapReduceParameters)this.parameter).map(MapReduceParameters::getMainJar).flatMap(mainJar -> ListUtils.emptyIfNull((List)this.converterContext.getDolphinSchedulerPackage().getResources()).stream().filter(res -> Objects.equals(res.getId(), mainJar.getId())).findFirst()).ifPresent(res -> ((MapReduceParameters)this.parameter).setMainJar(res));
        ListUtils.emptyIfNull((List)Optional.ofNullable((MapReduceParameters)this.parameter).map(MapReduceParameters::getResourceFilesList).orElse(ListUtils.emptyIfNull(null))).forEach(res -> ListUtils.emptyIfNull((List)this.converterContext.getDolphinSchedulerPackage().getResources()).stream().filter(res1 -> Objects.equals(res1.getId(), res.getId())).forEach(res1 -> BeanUtils.copyProperties((Object)res1, (Object)res)));
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String type = this.getConverterType();
        dwNode.setType(type);
        dwNode.setParameter(Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull((List)((MapReduceParameters)this.parameter).getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.toList())));
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_MR.name(), (CharSequence)dwNode.getType())) {
            String cmd = this.buildCommand((MapReduceParameters)this.parameter);
            cmd = this.replaceCode(cmd, dwNode);
            dwNode.setCode(cmd);
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.ODPS_MR.name(), (CharSequence)dwNode.getType())) {
            ResourceInfo mainJar2 = ((MapReduceParameters)this.parameter).getMainJar();
            ArrayList<String> codeLines = new ArrayList<String>();
            ArrayList<String> resources = new ArrayList<String>();
            if (mainJar2 != null) {
                String resourceName = mainJar2.getResourceName();
                if (resourceName == null) {
                    resourceName = this.getResourceNameById(mainJar2.getId());
                }
                resources.add(resourceName);
                codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resources));
            }
            String command = Joiner.on((String)" ").join((Object)"jar", (Object)"-resources", new Object[]{Optional.ofNullable(((MapReduceParameters)this.parameter).getMainJar().getName()).orElse(""), "-classpath", Joiner.on((String)",").join(resources), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainClass()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainArgs()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getOthers()).orElse("")});
            codeLines.add(command);
            String code = Joiner.on((String)"\n").join(codeLines);
            code = this.replaceCode(code, dwNode);
            dwNode.setCode(code);
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
            EmrCode emrCode = EmrCodeUtils.asEmrCode((Node)dwNode);
            Optional.ofNullable(emrCode).map(EmrCode::getLauncher).map(EmrLauncher::getAllocationSpec).map(EmrAllocationSpec::of).ifPresent(spec -> {
                spec.setQueue(((MapReduceParameters)this.parameter).getQueue());
                emrCode.getLauncher().setAllocationSpec(spec.toMap());
            });
        } else {
            throw new RuntimeException("not support type " + type);
        }
        return Arrays.asList(dwNode);
    }

    protected String buildCommand(MapReduceParameters mapreduceParameters) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(MrParameterConverter.buildArgs(mapreduceParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), new HashMap());
        log.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    public static List<String> buildArgs(MapReduceParameters param) {
        String mainArgs;
        String queue;
        String others;
        String appName;
        ArrayList<String> args = new ArrayList<String>();
        ResourceInfo mainJar = param.getMainJar();
        if (mainJar != null) {
            DolphinSchedulerV2Context context = DolphinSchedulerV2Context.getContext();
            String resourceName = CollectionUtils.emptyIfNull((Collection)context.getResources()).stream().filter(r -> r.getId() == mainJar.getId()).findAny().map(r -> r.getName()).orElse("");
            String resource = DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.EMR_MR, (String)"", Arrays.asList(resourceName));
            args.add(resource + resourceName);
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add(mainClass);
        }
        if (StringUtils.isNotEmpty((CharSequence)(appName = param.getAppName()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.name", ArgsUtils.escape((String)appName)));
        }
        if ((StringUtils.isEmpty((CharSequence)(others = param.getOthers())) || !others.contains("mapreduce.job.queuename")) && StringUtils.isNotEmpty((CharSequence)(queue = param.getQueue()))) {
            args.add(String.format("%s%s=%s", "-D", "mapreduce.job.queuename", queue));
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        return args;
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.mrNodeType");
        String defaultConvertType = CodeProgramType.EMR_MR.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

