/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DagData;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.entity.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.process.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.task.http.HttpParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v2.nodes.parameters.AbstractParameterConverter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class HttpParameterConverter
extends AbstractParameterConverter<HttpParameters> {
    public HttpParameterConverter(DagData processMeta, TaskDefinition taskDefinition, DolphinSchedulerConverterContext<Project, DagData, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() throws IOException {
        List param;
        DwNode dwNode = this.newDwNode(this.taskDefinition);
        String type = this.getConverterType();
        dwNode.setType(type);
        String cmd = "curl -X " + ((HttpParameters)this.parameter).getHttpMethod().name() + " -s -w \"\\n%{http_code}\" ";
        String url = ((HttpParameters)this.parameter).getUrl();
        ((HttpParameters)this.parameter).getHttpMethod().name();
        if (CollectionUtils.isNotEmpty((Collection)((HttpParameters)this.parameter).getHttpParams()) && CollectionUtils.isNotEmpty(param = ((HttpParameters)this.parameter).getHttpParams().stream().map(h -> h.getProp() + "=" + h.getValue()).collect(Collectors.toList()))) {
            String query = String.join((CharSequence)"&", param);
            url = url + "?" + query;
        }
        cmd = cmd + " '" + url + "' | { \n    read body \n    read code\n }";
        dwNode.setCode("# get http status $code get response body $body \n" + cmd);
        if (CodeProgramType.EMR_SHELL.name().equals(type)) {
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        }
        return Arrays.asList(dwNode);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.shellNodeType");
        String defaultConvertType = CodeProgramType.DIDE_SHELL.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

