/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.MapReduceArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.ProcessMeta;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.UdfFunc;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.datasource.DataSource;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.mr.MapReduceParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.DolphinSchedulerConverterContext;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.dolphinscheduler.v1.nodes.parameters.AbstractParameterConverter;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class MrParameterConverter
extends AbstractParameterConverter<MapReduceParameters> {
    public MrParameterConverter(ProcessMeta processMeta, TaskNode taskDefinition, DolphinSchedulerConverterContext<Project, ProcessMeta, DataSource, ResourceInfo, UdfFunc> converterContext) {
        super(processMeta, taskDefinition, converterContext);
    }

    @Override
    public List<DwNode> convertParameter() {
        EmrCode emrCode;
        String command;
        Optional.ofNullable((MapReduceParameters)this.parameter).map(MapReduceParameters::getMainJar).flatMap(mainJar -> ListUtils.emptyIfNull((List)this.converterContext.getDolphinSchedulerPackage().getResources()).stream().filter(res -> Objects.equals(res.getId(), mainJar.getId())).findFirst()).ifPresent(res -> ((MapReduceParameters)this.parameter).setMainJar(res));
        ListUtils.emptyIfNull((List)Optional.ofNullable((MapReduceParameters)this.parameter).map(MapReduceParameters::getResourceFilesList).orElse(ListUtils.emptyIfNull(null))).forEach(res -> ListUtils.emptyIfNull((List)this.converterContext.getDolphinSchedulerPackage().getResources()).stream().filter(res1 -> Objects.equals(res1.getId(), res.getId())).forEach(res1 -> BeanUtils.copyProperties((Object)res1, (Object)res)));
        DwNode dwNode = this.newDwNode(this.processMeta, this.taskDefinition);
        String type = this.getConverterType();
        dwNode.setType(type);
        dwNode.setParameter(Joiner.on((String)" ").join((Iterable)ListUtils.emptyIfNull((List)((MapReduceParameters)this.parameter).getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.toList())));
        List resources = ListUtils.emptyIfNull((List)((MapReduceParameters)this.parameter).getResourceFilesList()).stream().filter(Objects::nonNull).map(ResourceInfo::getName).distinct().collect(Collectors.toList());
        ArrayList<String> codeLines = new ArrayList<String>();
        codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)dwNode.getType()), (String)"", resources));
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_MR.name(), (CharSequence)dwNode.getType())) {
            command = Joiner.on((String)" ").join((Iterable)MapReduceArgsUtils.buildArgs((MapReduceParameters)((MapReduceParameters)this.parameter)).stream().map(String::valueOf).collect(Collectors.toList()));
            codeLines.add(command);
            dwNode.setCode(Joiner.on((String)"\n").join(codeLines));
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
            emrCode = EmrCodeUtils.asEmrCode((Node)dwNode);
            Optional.ofNullable(emrCode).map(EmrCode::getLauncher).map(EmrLauncher::getAllocationSpec).map(EmrAllocationSpec::of).ifPresent(spec -> {
                spec.setQueue(((MapReduceParameters)this.parameter).getQueue());
                emrCode.getLauncher().setAllocationSpec(spec.toMap());
            });
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.ODPS_MR.name(), (CharSequence)dwNode.getType())) {
            command = Joiner.on((String)" ").join((Object)"jar", (Object)"-resources", new Object[]{Optional.ofNullable(((MapReduceParameters)this.parameter).getMainJar().getName()).orElse(""), "-classpath", Joiner.on((String)",").join(resources), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainClass()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getMainArgs()).orElse(""), Optional.ofNullable(((MapReduceParameters)this.parameter).getOthers()).orElse("")});
            codeLines.add(command);
            dwNode.setCode(Joiner.on((String)"\n").join(codeLines));
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
            emrCode = EmrCodeUtils.asEmrCode((Node)dwNode);
            Optional.ofNullable(emrCode).map(EmrCode::getLauncher).map(EmrLauncher::getAllocationSpec).map(EmrAllocationSpec::of).ifPresent(spec -> {
                spec.setQueue(((MapReduceParameters)this.parameter).getQueue());
                emrCode.getLauncher().setAllocationSpec(spec.toMap());
            });
        }
        return Arrays.asList(dwNode);
    }

    private String getConverterType() {
        String convertType = this.properties.getProperty("workflow.converter.mrNodeType");
        String defaultConvertType = CodeProgramType.EMR_MR.name();
        return this.getConverterType(convertType, defaultConvertType);
    }
}

