/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.datago;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.ModelTreeRoot;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DgDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DgDatasourceUtil;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.DataGoTask;
import com.aliyun.dataworks.migrationx.domain.dataworks.datago.DsfCycle;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwDatasource;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.FolderUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectAssetLoader;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItem;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportItemType;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.IntlUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGOConverter
extends AbstractBaseConverter {
    private static final Logger log = LoggerFactory.getLogger(DataGOConverter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DataGOConverter.class);
    private static final String JSON_FILE_SUFFIX = ".json";
    private static final List<String> FILTER_FILE = Arrays.asList("envUUID.json", "resources.json");
    private ConcurrentMap<String, DwWorkflow> dwWorkflowConcurrentMap = new ConcurrentHashMap<String, DwWorkflow>();
    private Project project;
    private Properties properties;
    protected Map<String, DgDatasource> datasourceMap;

    public DataGOConverter() {
        super(AssetType.DATAGO, "DataGOConverter");
    }

    public DataGOConverter(AssetType assetType, String name, ProjectAssetLoader projectAssetLoader) {
        super(assetType, name, projectAssetLoader);
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        this.properties = this.propertiesLoader != null && this.properties == null ? (Properties)this.propertiesLoader.getResult() : this.properties;
        this.datasourceMap = DgDatasourceUtil.processDatasource((File)new File(asset.getPath(), "datasource.xlsx"));
        List<DwWorkflow> list = this.convertWorkflowList(asset);
        ListUtils.emptyIfNull(list).forEach(wf -> ListUtils.emptyIfNull((List)wf.getNodes()).stream().peek(n -> NodeUtils.setProjectRootDependencyIfIsolated((Project)this.project, (DwWorkflow)wf, (Node)n)).filter(n -> CodeProgramType.DI.name().equalsIgnoreCase(n.getType())).forEach(n -> {
            this.processFtpRootPath((Node)n, this.datasourceMap);
            NodeUtils.setProjectRootDependencyIfIsolated((Project)this.project, (DwWorkflow)wf, (Node)n);
        }));
        this.project.setDatasources(DgDatasourceUtil.convertDatasources(this.datasourceMap));
        ListUtils.emptyIfNull((List)this.project.getDatasources()).forEach(ds -> ((DwDatasource)ds).setProjectRef(this.project));
        return list;
    }

    private void processFtpRootPath(Node node, Map<String, DgDatasource> datasourceMap) {
        String code = node.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            return;
        }
        JsonObject diJson = (JsonObject)GsonUtils.gson.fromJson(code, JsonObject.class);
        if (diJson == null) {
            return;
        }
        if (!diJson.has("steps")) {
            return;
        }
        JsonArray steps = diJson.get("steps").getAsJsonArray();
        if (steps.size() == 0) {
            return;
        }
        for (int i = 0; i < steps.size(); ++i) {
            DgDatasource dgDatasource;
            JsonObject step = steps.get(i).getAsJsonObject();
            if (!step.has("parameter")) continue;
            JsonObject parameter = step.get("parameter").getAsJsonObject();
            String datasource = null;
            if (parameter.has("datasourceId")) {
                Long datasourceId = parameter.get("datasourceId").getAsLong();
                datasource = datasourceMap.values().stream().filter(ds -> datasourceId != null && datasourceId.equals(ds.getId())).findAny().map(DgDatasource::getName).orElse(null);
            }
            if (StringUtils.isBlank(datasource) && parameter.has("datasourceName")) {
                datasource = parameter.get("datasourceName").getAsString();
            }
            if (StringUtils.isBlank(datasource) && parameter.has("datasource")) {
                datasource = parameter.get("datasource").getAsString();
            }
            if (StringUtils.isBlank(datasource)) {
                LOGGER.warn("datasource not found, node: {}", (Object)node.getName());
                continue;
            }
            parameter.addProperty("datasource", datasource);
            parameter.addProperty("datasourceName", datasource);
            if (!step.has("stepType") || Arrays.asList("sftp", "ftp").stream().noneMatch(t -> t.equalsIgnoreCase(step.get("stepType").getAsString())) || (dgDatasource = datasourceMap.get(datasource)) == null || !StringUtils.isNotBlank((CharSequence)dgDatasource.getRootPath()) || !parameter.has("path")) continue;
            JsonElement pathEle = parameter.get("path");
            JsonArray path = new JsonArray();
            if (pathEle.isJsonArray()) {
                path = parameter.get("path").getAsJsonArray();
            } else {
                path.add(pathEle.getAsString());
            }
            if (path == null || path.size() <= 0) continue;
            JsonArray pathList = new JsonArray();
            for (int j = 0; j < path.size(); ++j) {
                String p = path.get(j).getAsString();
                p = Joiner.on((String)File.separator).join((Object)dgDatasource.getRootPath(), (Object)p, new Object[0]);
                pathList.add(p);
            }
            parameter.add("path", (JsonElement)pathList);
        }
        node.setCode(GsonUtils.defaultGson.toJson((JsonElement)diJson));
    }

    public List<DwWorkflow> convertWorkflowList(Asset asset) throws Exception {
        this.workflowList = new ArrayList();
        File dir = asset.getPath();
        if (null == dir || !dir.exists()) {
            log.error("[DataGO] asset dir invalid");
            return ListUtils.emptyIfNull(null);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = dir.listFiles(file -> file.isFile() && file.getName().endsWith(JSON_FILE_SUFFIX) && !FILTER_FILE.contains(file.getName()));
        File[] directoryFile = dir.listFiles(File::isDirectory);
        if (null != directoryFile && directoryFile.length > 0) {
            for (File value : directoryFile) {
                File[] childFiles = value.listFiles(file -> file.isFile() && file.getName().endsWith(JSON_FILE_SUFFIX) && !FILTER_FILE.contains(file.getName()));
                if (null == childFiles) continue;
                fileList.addAll(Arrays.asList(childFiles));
            }
        }
        if (null != files) {
            fileList.addAll(Arrays.asList(files));
        }
        if (fileList.size() <= 0) {
            log.error("[DataGO] json file invalid");
            return ListUtils.emptyIfNull(null);
        }
        this.convertWorkflow(fileList);
        this.workflowList.addAll(new ArrayList(this.dwWorkflowConcurrentMap.values()));
        this.checkCycle();
        return this.workflowList;
    }

    public void convertWorkflow(List<File> fileList) throws Exception {
        for (File jsonFile : fileList) {
            String json = IOUtils.toString((Reader)new FileReader(jsonFile));
            List tasks = (List)GsonUtils.defaultGson.fromJson(json, new TypeToken<List<DataGoTask>>(){}.getType());
            ListUtils.emptyIfNull((List)tasks).forEach(dataGoTask -> {
                DwWorkflow dwWorkflow = this.getWorkflow();
                try {
                    dataGoTask.setProperties(this.properties);
                    List dwNodes = dataGoTask.toNodes(this.project.getName(), this.datasourceMap);
                    dwNodes.stream().forEach(dwNode -> dwNode.setWorkflowRef((Workflow)dwWorkflow));
                    ListUtils.emptyIfNull((List)dwNodes).forEach(dwNode -> this.getNodeFolder((DwNode)dwNode, (DataGoTask)dataGoTask));
                    if (BooleanUtils.isTrue((Boolean)dwWorkflow.getScheduled())) {
                        dwNodes.forEach(dwNode -> dwNode.setNodeUseType(NodeUseType.SCHEDULED));
                    } else {
                        dwNodes.forEach(dwNode -> dwNode.setNodeUseType(NodeUseType.MANUAL_WORKFLOW));
                    }
                    dwWorkflow.getNodes().addAll(dwNodes);
                    if (!dataGoTask.getSuccess().booleanValue()) {
                        ReportItem reportItem = new ReportItem();
                        reportItem.setName(jsonFile.getName() + ":" + dataGoTask.getTaskInstModel().getName());
                        reportItem.setType(ReportItemType.DataGO_FILE_TO_NODE_FAILURE.name());
                        reportItem.setMessage("datago job convert error: " + dataGoTask.getTaskInstModel().getName());
                        this.reportItems.add(reportItem);
                        throw new Exception(reportItem.getMessage());
                    }
                }
                catch (Exception e) {
                    log.error("[DataGO] to node exception, file:{} ", (Object)jsonFile, (Object)e);
                    throw BizException.of((ErrorCode)ErrorCode.PACKAGE_CONVERT_FAILED).with(new Object[]{jsonFile.getName() + ":" + e.getMessage()});
                }
            });
        }
    }

    private void getNodeFolder(DwNode dwNode, DataGoTask dataGoTask) {
        ModelTreeRoot modelTreeRoot = null;
        if (dwNode.getWorkflowRef() != null) {
            modelTreeRoot = FolderUtils.getModelTreeRoot((Workflow)dwNode.getWorkflowRef());
        }
        if (StringUtils.isNotBlank((CharSequence)dataGoTask.getTreePathOfName())) {
            List parts = Arrays.stream(dataGoTask.getTreePathOfName().split("/")).filter(s -> !s.equalsIgnoreCase(dwNode.getName()) && StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(parts)) {
                dwNode.setFolder("/");
            } else {
                dwNode.setFolder(Joiner.on((String)"/").join(parts));
            }
        } else {
            dwNode.setFolder("/");
        }
        if (modelTreeRoot != null) {
            dwNode.setFolder(Joiner.on((String)"/").join((Object)modelTreeRoot.getRootKey(), (Object)IntlUtils.get((String)"DATA_GO").d("DATA_GO"), new Object[]{dwNode.getFolder().replaceFirst("^/", "")}));
        }
    }

    private DwWorkflow getWorkflow() {
        return this.getDefaultWorkflow("OLD_VERSION_WORKFLOW");
    }

    private DwWorkflow getDefaultWorkflow(String name) {
        if (this.dwWorkflowConcurrentMap.containsKey(name)) {
            return (DwWorkflow)this.dwWorkflowConcurrentMap.get(name);
        }
        DwWorkflow dwWorkflow = new DwWorkflow();
        dwWorkflow.setName(name);
        dwWorkflow.setScheduled(Boolean.TRUE);
        this.dwWorkflowConcurrentMap.putIfAbsent(name, dwWorkflow);
        return dwWorkflow;
    }

    private void checkCycle() {
        DsfCycle dsfCycle = new DsfCycle();
        this.workflowList.forEach(dwWorkflow -> {
            List cycleResult;
            List dwNodes = dwWorkflow.getNodes();
            if (CollectionUtils.isNotEmpty((Collection)dwNodes)) {
                dwNodes.forEach(node -> {
                    String nodeName = node.getName();
                    if (!nodeName.contains(".")) {
                        nodeName = Joiner.on((String)".").join((Object)dwWorkflow.getName(), (Object)nodeName, new Object[0]);
                    }
                    List inputs = node.getInputs();
                    String finalNodeName = nodeName;
                    inputs.forEach(nodeIo -> dsfCycle.addLine(nodeIo.getData(), finalNodeName));
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(cycleResult = dsfCycle.findCycle()))) {
                StringBuilder builder = new StringBuilder();
                cycleResult.forEach(s -> builder.append((String)s).append(","));
                ReportItem reportItem = new ReportItem();
                reportItem.setName(dwWorkflow.getName());
                reportItem.setType(ReportItemType.EXIST_CYCLE.name());
                reportItem.setMessage(builder.toString());
                this.reportItems.add(reportItem);
            }
        });
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

